package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel(value = "com-junmp-jyzb-domain-EquipmentSize")
@Data
@AllArgsConstructor
@NoArgsConstructor
@TableName("base_equipment_size")
public class EquipmentSize implements Serializable {
    /**
     * 装备号型ID
     */
    @ApiModelProperty(value = "装备号型ID")
    @TableField("id")
    private String id;

    /**
     * 装备类型ID
     */
    @TableField("type_id")
    private String typeId;


    /**
     * 号型码
     */
    private String code;

    /**
     * 号型名称
     */
    private String name;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间")
    @TableField(value = "update_time", fill = FieldFill.UPDATE)
    private Date updateTime;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String note;

    /**
     * 价格
     */
    @ApiModelProperty(value = "价格")
    private BigDecimal price;

    /**
     * 当前状态：0关闭/1启用
     */
    @ApiModelProperty(value = "当前状态：0关闭/1启用")
    private Integer state;

    /**
     * EPC类型
     */
    @ApiModelProperty(value = "EPC类型")
    @TableField("epc_type")
    private Integer epcType;

    private static final long serialVersionUID = 1L;
}