package com.junmp.jyzb.controller;

import cn.hutool.core.util.ObjectUtil;
import com.junmp.jyzb.api.bean.dto.OrderDto;
import com.junmp.jyzb.api.bean.dto.OrderMainDto;
import com.junmp.jyzb.api.bean.query.OrderMainReq;
import com.junmp.jyzb.api.bean.query.OrderUploadReq;
import com.junmp.jyzb.api.bean.req.BaseOrderReq;
import com.junmp.jyzb.api.bean.req.UpdateOrderReq;
import com.junmp.jyzb.service.OrderMainService;
import com.junmp.jyzb.service.HandoverService;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

@RestController
@Slf4j
@RequestMapping("/Order")
@Api(tags = "业务模块")
public class OrderController {
    @Resource
    public OrderMainService orderMainService;

    @Resource
    public HandoverService handoverService;

    //通过工作流进行操作处理的
    @PostMapping("/AddOrder")
    @ApiOperation("新增任务单")
    public ApiRes<List<String>> addOrder(@RequestBody UpdateOrderReq req) {
        //判断是否有工作流id，如果有则将状态进行修改
        if (ObjectUtil.isEmpty(req.getProcessId()))
        {
            req.setExamineState("none");
        }
        else
        {
            req.setExamineState("working");
        }
        return ApiRes.success(orderMainService.AddOrder(req));
    }

    //审批通过后修改单子状态为finished并推送到消息队列中



    //内部处理，任务单状态直接设置成finished 添加到数据并且直接推送到消息队列中去
    @PostMapping("/AddFinishOrder")
    @ApiOperation("新增已完成的任务单")
    public ApiRes<String> AddFinishOrder(@RequestBody UpdateOrderReq req)  {
        req.setExamineState("finished");
        return ApiRes.success(orderMainService.AddFinishOrder(req));
    }


    //修改任务单只允许工作流id为空的时候（视为草稿可以进行修改）
    @PostMapping("/UpdateOrder")
    @ApiOperation("修改任务单")
    public ApiRes<Boolean>  updateOrder(@RequestBody @Validated(ValidationApi.edit.class) UpdateOrderReq req) {
        return ApiRes.success(orderMainService.updateOrder(req));
    }

    //查询任务列表(根据组织机构id)
    @PostMapping("/GetOrderPage")
    @ApiOperation("/查询任务列表")
    public ApiRes<PageResult<OrderMainDto>> getOrderPage(@RequestBody @Validated(ValidationApi.add.class)OrderMainReq req ){
        return ApiRes.success(orderMainService.getOrderPage(req));
    }

    @PostMapping("/GetDetailById")
    @ApiOperation("根据任务单id查看业务明细")
    public ApiRes<OrderDto> GetDetailById(@RequestBody @Validated(ValidationApi.detail.class) OrderMainReq req){
        return ApiRes.success(orderMainService.GetDetailById(req));
    }

    @PostMapping("/PushState")
    @ApiOperation("单据状态上报")
    public ApiRes<Boolean> PushState(@RequestBody @Validated(ValidationApi.delete.class) OrderUploadReq req){
        return ApiRes.success(orderMainService.PushState(req));
    }

    @PostMapping("/Accounting")
    @ApiOperation("记账")
    public ApiRes<Boolean> Accounting(@RequestBody @Validated(ValidationApi.delete.class) OrderMainReq req){
        return ApiRes.success(orderMainService.Accounting(req));
    }

//    //将工作单添加到rabbitmq中去
//    @PostMapping("/AddOrderRabbitMq")
//    @ApiOperation("将工作单添加到rabbitmq消息队列中去")
//    public ApiRes<Boolean> AddOrderRabbitMq(){
//        List<OrderDto> order = orderMainService.getOrder();
//        List<String> orderId=new ArrayList<>();
//        for (OrderDto orderDto:order) {
//            //将routingKey设置为收物机构id
//            rabbitTemplate.convertAndSend("OrderExchange",orderDto.getEndOrgId(),orderDto);
//            orderId.add(orderDto.getId());
//        }
//        //将未被上传的数据进行上传到rabbitmq中，同时添加到数据库，标记为已上传数据，比避免同意数据多次或者重复上传
//        boolean b = orderLogService.addOrder(orderId);
//        return ApiRes.success(true);
//    }



    //个人装备管理申请单（移交申请）
    @PostMapping("/AddPersonalEqsOrder")
    @ApiOperation("/新增个人装备申请单")
    public ApiRes<List<String>> AddPersonalEqsOrder(@RequestBody BaseOrderReq req){
        //判断是否有工作流id，如果有则将状态进行修改
        if (ObjectUtil.isEmpty(req.getProcessId()))
        {
            req.setExamineState("none");
        }
        else
        {
            req.setExamineState("working");
        }
        return ApiRes.success(handoverService.EquipmentHandover(req));
    }

    //个人装备管理申请单的修改（移交申请）
    @PostMapping("/UpdatePersonalEqsOrder")
    @ApiOperation("修改个人装备申请单")
    public ApiRes<Boolean>  UpdatePersonalEqsOrder(@RequestBody BaseOrderReq req) {
        return ApiRes.success(handoverService.UpdatePersonalEqsOrder(req));
    }

}
