package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.query.OrderMainReq;
import com.junmp.jyzb.entity.OrderLog;
import com.junmp.jyzb.service.OrderLogService;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.common.bean.response.ApiRes;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

@RestController
@Slf4j
@RequestMapping("/Log")
@Api(tags = "日志模块")
public class LogController {
    @Resource
    private OrderLogService orderLogService;
    //查看单据日志(通过组织机构id和出入库状态)
    @PostMapping("/getLogsList")
    @ApiOperation("获取日志")
    public ApiRes<List<OrderLog>> getLogsList(@RequestBody @Validated(ValidationApi.edit.class) OrderMainReq req){
        return ApiRes.success(orderLogService.getLogsList(req));
    }
}
