package com.junmp.jyzb.controller;

import cn.hutool.core.util.StrUtil;
import com.junmp.jyzb.api.bean.query.CompanyReq;
import com.junmp.jyzb.doc.CompanyDoc;
import com.junmp.jyzb.entity.Company;
import com.junmp.jyzb.service.CompanyService;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.exception.enums.DefaultBizExceptionEnum;
import com.junmp.v2.db.api.page.PageResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2022/8/1 10:24
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@RestController
@Slf4j
@RequestMapping("/api")
public class CompanyController implements CompanyDoc {

    @Resource
    private CompanyService companyService;


    @PostMapping(path = "/company", name = "新增企业")
    @Override
    public ApiRes<Boolean> addBiz(@RequestBody @Validated(CompanyReq.add.class) CompanyReq req) {
        try {
            companyService.addBiz(req);
            return ApiRes.success();
        } catch (ServiceException ex) {
            log.error("企业新增异常>>" + ex.getMessage());
            return ApiRes.failure(DefaultBizExceptionEnum.SYS_RUNTIME_ERROR);
        }
    }

    @PutMapping(path = "/company", name = "编辑企业")
    @Override
    public ApiRes<Boolean> editBiz(@RequestBody @Validated(ValidationApi.edit.class) CompanyReq req) {
        boolean flag = companyService.editBiz(req);
        if (flag) {
            return ApiRes.success();
        } else {
            return ApiRes.failure(StrUtil.format("单位编码:{},更新失败", req.getBizCode()));
        }
    }

    @GetMapping(path = "/company", name = "企业列表")
    @Override
    public ApiRes<List<Company>> list(CompanyReq req) {
        List<Company> list = companyService.findList(req);
        return ApiRes.success(list);
    }

    @DeleteMapping(path = "/company", name = "删除企业")
    @Override
    public ApiRes<Boolean> delBiz(@RequestBody @Validated(ValidationApi.delete.class) CompanyReq req) {
        boolean flag = companyService.del(req);
        if (flag) {
            return ApiRes.success();
        } else {
            return ApiRes.failure(StrUtil.format("单位编码:{},删除失败", req.getBizCode()));
        }
    }

    @GetMapping(path = "/company/page", name = "分页企业信息")
    @Override
    public ApiRes<PageResult<Company>> page(CompanyReq req) {
        return ApiRes.success(companyService.findPage(req));
    }
}
