package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.dto.CabinetDto;
import com.junmp.jyzb.api.bean.query.CabinetBoxReq;
import com.junmp.jyzb.api.bean.query.CabinetReq;
import com.junmp.jyzb.api.bean.req.UpdateCabinetReq;
import com.junmp.jyzb.entity.CabinetBox;
import com.junmp.jyzb.service.CabinetBoxService;
import com.junmp.jyzb.service.CabinetService;
import com.junmp.jyzb.utils.ResponseResult;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

@RestController
@Slf4j
@RequestMapping("/Cabinet")
@Api(tags = "单警柜基础信息模块")
public class CabinetController {
    @Resource
    public CabinetService cabinetService;

    @Resource
    private CabinetBoxService cabinetBoxService;


    @PostMapping("/AddCabinetInfo")
    @ApiOperation("添加单警柜信息")
    public ApiRes<String> addCabinetInfo(@RequestBody @Validated(ValidationApi.add.class) UpdateCabinetReq req){
        String cabinetId = cabinetService.addCabinetInfo(req);
        return ApiRes.success(cabinetId);
    }

    @PostMapping("/ErrorState")
    @ApiOperation("单警柜状态变更")
    public ApiRes<Boolean> ChangeCabinetState(@RequestBody UpdateCabinetReq req) {
        boolean result = cabinetService.ChangeCabinetState(req);
        if (!result){
            return ApiRes.failure("操作失败");
        }
        return ApiRes.success(result);
    }


    @PostMapping("/DeleteCabinetInfo")
    @ApiOperation("删除单警柜信息")
    public ApiRes<Boolean> deleteCabinetInfo(@RequestBody @Validated(ValidationApi.delete.class) UpdateCabinetReq req) {
        return ApiRes.success(cabinetService.deleteCabinetInfo(req));
    }

    @PostMapping("/UpdateCabinetInfo")
    @ApiOperation("修改单警柜信息")
    public ApiRes<Boolean> updateCabinetInfo(@RequestBody  UpdateCabinetReq req) {
        boolean result = cabinetService.updateCabinetInfo(req);
        if (!result){
            return ApiRes.failure("操作失败");
        }
        return ApiRes.success(result);
    }



    //通过单警柜id查询单个箱门及其箱门信息
    @PostMapping("/ShowOneCabinet")
    @ApiOperation("查询单个单警柜及其箱门信息")
    public ApiRes<CabinetDto> showOneCabinet(@RequestBody @Validated(ValidationApi.detail.class) CabinetReq req){
        return ApiRes.success(cabinetService.showOneCabinet(req));
    }


    //根据组织机构id查询出单警柜的详细信息(list)
    @PostMapping("/ShowCabinetList")
    @ApiOperation("查询单警柜列表")
    public ApiRes<List<CabinetDto>> showCabinetList(@RequestBody CabinetReq req){
        List<CabinetDto> allCabinetList = cabinetService.getAllCabinetList(req);
        return ApiRes.success(allCabinetList);
    }

    //根据组织机构id查询出单警柜的详细信息(page)
    @PostMapping("/ShowCabinetPage")
    @ApiOperation("查询单警柜列表")
    public ApiRes<PageResult<CabinetDto>> ShowCabinetPage(@RequestBody CabinetReq req){
        return ApiRes.success(cabinetService.ShowCabinetPage(req));
    }



    @PostMapping("/boxBindPolice")
    @ApiOperation("箱门绑定人员")
    public ApiRes<Boolean> boxBindPolice(@RequestBody CabinetBoxReq req) {
        boolean result = cabinetService.boxBindPolice(req);
        if (!result){
            return ApiRes.failure("操作失败");
        }
        return ApiRes.success(result);
    }

    @PostMapping("/SearchOrgId")
    @ApiOperation("/根据单警柜id查询组织机构id")
    public ApiRes<Long> SearchOrgId(@RequestBody @Validated(ValidationApi.detail.class) CabinetReq req){
        return ApiRes.success(cabinetService.SearchOrgId(req));
    }

}