package com.junmp.jyzb.api.bean.query;

import com.junmp.v2.common.bean.request.BaseRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2022/8/2 14:36
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class ProductTagReq extends BaseRequest {

    /**
     * 标签编号
     */
    @NotNull(message = "标签编号不能为空", groups = {edit.class, delete.class, detail.class})
    private Long tagId;


    private String tagUid;

    /**
     * 成品码（批次+序号）
     */
    private String productCode;

    /**
     * 关联生成批次编号
     */
    @NotNull(message = "批次不能为空", groups = {add.class})
    private Long batchId;

    /**
     * 关联生成产品主键
     */
    @NotNull(message = "产品不能为空", groups = {add.class})
    private Long productId;

    /**
     * 关联生成号型主键
     */
    @NotNull(message = "号型不能为空", groups = {add.class})
    private Long specId;

    /**
     * 产品序号
     */
    private Integer serialId;

    /**
     * 版本编号
     */
    private String versionNo;

    /**
     * 密码
     */
    private String password;

    /**
     * 密文内容
     */
    private String ciphertext;
}
