package com.junmp.jyzb.api.bean.query;

import com.junmp.v2.common.bean.request.BaseRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = true)
public class PolicemanReq extends BaseRequest {

    @NotBlank(message = "警员主键不能为空", groups = {add.class,edit.class, delete.class, detail.class})
    private String id;

    @NotBlank(message = "姓名不能为空", groups = {add.class})
    private String name;

    @NotBlank(message = "箱门id不能为空", groups = {edit.class, delete.class})
    private String cabinetBoxId;

    @NotNull(message = "组织机构id不能为空",groups = {add.class})
    private Long orgId;

    private Long departmentId;

    private String policeCode;

    @NotBlank(message = "性别不能为空", groups = {add.class})
    private String sex;

    private String faceInfo;

    //1已生成，0未生成
    private Integer isCreatedAccount;

    private String doorCode;

    //账号
    @NotBlank(message = "账号不能为空", groups = {add.class})
    private String account;

    //密码
    @NotBlank(message = "密码不能为空", groups = {add.class})
    private String password;

    private String photo;

    @NotBlank(message = "电话不能为空", groups = {add.class})
    private String phone;

    private Date createTime;

    private Date updateTime;

    private String idCard;

    private String updateUser;

    private Integer state;

    private static final long serialVersionUID = 1L;
}