package com.junmp.jyzb.api.bean.query;

import com.junmp.v2.common.bean.request.BaseRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;
import java.util.List;

/**
 *
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class OrderUploadReq extends BaseRequest {
    /**
     * 主订单id
     */
    @NotBlank(message = "单据主id不能为空",groups = {detail.class})
    private String id;
    /**
     * 单据状态 ready待入/出库，finished已入/出库，working入/出库中
     */
    private String orderState;
    /**
     * 计划数量
     */
    private Integer inventoryQuantity;
    /**
     * 实际数量
     */
    private Integer actualQuantity;
    /**
     * 总价格
     */
    private BigDecimal price;
    /**
     *childrenOrder(集合)，子单据
     */
    private List<OrderUploadDetailReq> childrenOrder;

    /**
     * 记账人id
     */
    private String updateUserId;

    /**
     * 记账人（修改人员）
     */
    private String updateUser;

    /**
     * 组织机构id（出库单存放id）
     */
    private Long startOrgId;

    /**
     * 组织机构id（入库单存放id）
     */
    private Long endOrgId;

    /**
     * 单据类型（入库in，出库out）
     */
    private String orderType;

    @Getter
    public class OrderUploadDetailReq{
        /**
         * 子单据ID
         */
        private Long detailId;
        /**
         * 应入库数量(计划数量)
         */
        private Integer planNum;
        /**
         * 修改后数量
         */
        private Integer modifyQuantity;
        /**
         * 实际数量
         */
        private Integer actualNum;
        /**
         * 订单状态 ready待入/出库，working入/出库中，finished已完成
         */
        private String orderType;

        /**
         * 物资类型id
         */
        private String typeId;

        /**
         * 物资类型名称
         */
        private String typeName;

        /**
         * 物资号型id
         */
        private Long sizeId;

        /**
         * 物资号型名称
         */
        private String sizeName;
        /**
         * 价格
         */
        private BigDecimal price;
    }
}
