package com.junmp.jyzb.api.bean.dto;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
public class LogSummaryDto implements Serializable {

    /**
     * 组织机构ID
     */
    @ApiModelProperty(value = "组织机构ID")
    private String orgId;

    /**
     * 组织机构名称
     */
    @ApiModelProperty(value = "组织机构名称")
    private String orgName;

    /**
     * 单据id
     */
    @ApiModelProperty(value = "单据id")
    private String orderMainId;

    /**
     * 存储ID
     */
    @ApiModelProperty(value = "存储ID")
    private String locationId;

    /**
     * 存储名称：XX仓库，XX单警柜
     */
    @ApiModelProperty(value = "存储名称")
    private String locationName;

    /**
     * 设备标识
     */
    @ApiModelProperty(value = "设备标识")
    private String device;

    /**
     * 出入设备:0手持机/1单警柜/2通道
     */
    @ApiModelProperty(value = "出入设备:0手持机/1单警柜/2通道")
    private Integer deviceType;

    /**
     * 操作时间
     */
    @ApiModelProperty(value = "操作时间")
    private Date useTime;

    /**
     * 业务类型
     */
    @ApiModelProperty(value = "业务类型")
    private String bussinessType;
    /**
     * 操作人员姓名
     */
    @ApiModelProperty(value = "操作人员姓名")
    private String userName;

    /**
     * 出入库类型:0出库/1入库
     */
    @ApiModelProperty(value = "出入库类型:0出库/1入库")
    private Integer outInState;

    /**
     * 照片信息
     */
    @ApiModelProperty(value = "照片信息")
    private String picture;

    /**
     * 装备记录集合，警棍、盾牌
     */
    @ApiModelProperty(value = "装备记录集合")
    private String equipments;

    /**
     * 装备详细信息
     */
    @ApiModelProperty(value = "装备详细信息")
    private List<LogDetailDto> equipmentList;


}
