package com.junmp.jyzb.mapper;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.junmp.jyzb.api.bean.dto.TjDto.TjOutAndInDto;
import com.junmp.jyzb.api.bean.query.LogSummaryReq;
import com.junmp.jyzb.api.bean.query.TjReq.TjOrgCountReq;
import com.junmp.jyzb.entity.LogSummary;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
* @author lxh专属坐骑
* @description 针对表【base_log_summary】的数据库操作Mapper
* @createDate 2023-10-13 08:29:36
* @Entity com.junmp.jyzb.entity.LogSummary
*/
public interface LogSummaryMapper extends BaseMapper<LogSummary> {

    List<TjOutAndInDto> TjOutAndInCount(@Param("req") TjOrgCountReq req);

    List<LogSummary> ShowInOutRecords(@Param("orgId")Long orgId, @Param("sizeId")String sizeId,
                                      @Param("typeId")String typeId, @Param("price")BigDecimal price,
                                      @Param("pageNo")Long pageNo,@Param("pageSize")Long pageSize);

    int ShowInOutRecordsSum(@Param("orgId")Long orgId, @Param("sizeId")String sizeId,
                            @Param("typeId")String typeId, @Param("price")BigDecimal price);

    LogSummary ShowInOutRecordsByItemsCount(@Param("req") LogSummaryReq req);

    List<LogSummary> RecordSumByOrderId(@Param("req") LogSummaryReq req,
                                        @Param("pageNo")Long pageNo,
                                        @Param("pageSize")Long pageSize);

    int RecordSumByOrderIdSum(@Param("req") LogSummaryReq req);
}




