package com.junmp.jyzb.api.bean.req;

import com.junmp.v2.common.bean.request.ValidationApi;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class UpdateWarehouseDevReq {

    private String id;

    /**
     * 仓库id
     */
    private String warehouseId;

    /**
     * 组织机构id
     */
    @NotNull(message = "组织机构id不能为空",groups = {ValidationApi.list.class})
    private Long orgId;
    /**
     * Ip地址
     */
    private String devIp;

    /**
     * 端口
     */
    private String devPort;

    /**
     * 名称
     */
    private String devName;

    /**
     * 设备mac
     */
    private String devCode;

    /**
     * 湿度
     */
    private String warehouseSd;

    /**
     * 温度
     */
    private String warehouseWd;

    /**
     * 设定的开关
     */
    private String setState;

    /**
     * 状态：0关闭1开启
     */
    private Integer devState;

    /**
     * 设定的温度
     */
    private Integer setSd;

    private Date createTime;

    private Long updateTime;

    //rabbitmq消息有关参数
    private String api;
    private String msg;
    //rabbitmq消息有关参数
    private Integer type;

    //是否暂存（true表示暂存不会下发到本地主机，如果为空或者是为false则表示直接下发通知到本地主机）
    private Boolean flag;

}
