package com.junmp.jyzb.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.junmpProcess.dto.StartProcessInstanceDTO;
import com.junmp.junmpProcess.service.IFlowInstanceService;
import com.junmp.jyzb.Repository.BusFormRepository;
import com.junmp.jyzb.api.bean.dto.BusFormDto;
import com.junmp.jyzb.api.bean.dto.GeneratePurchaseQuicklyDto;
import com.junmp.jyzb.api.bean.query.BussinessOrderDetialReq;
import com.junmp.jyzb.api.bean.query.InventorySumReq;
import com.junmp.jyzb.api.bean.query.QueryBusFormReq;
import com.junmp.jyzb.api.bean.query.QueryEquipmentTypeReq;
import com.junmp.jyzb.api.bean.req.GeneratePurchaseQuicklyReq;
import com.junmp.jyzb.api.bean.req.UpdateBusFormReq;
import com.junmp.jyzb.api.exception.enums.OrderExceptionEnum;
import com.junmp.jyzb.entity.*;
import com.junmp.jyzb.mapper.InventorySummaryMapper;
import com.junmp.jyzb.service.BusFormService;
import com.junmp.jyzb.mapper.BusFormMapper;
import com.junmp.jyzb.service.InventorySummaryService;
import com.junmp.jyzb.service.StocktakeService;
import com.junmp.jyzb.utils.DateTimeUtil;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.db.api.factory.PageResultFactory;
import com.junmp.v2.db.api.page.PageResult;
import com.junmp.v2.sys.user.entity.SysUserOrg;
import com.junmp.v2.sys.user.service.SysUserOrgService;
import org.flowable.engine.TaskService;
import org.flowable.task.api.Task;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

/**
* @author lxh专属坐骑
* @description 针对表【base_bus_form】的数据库操作Service实现
* @createDate 2023-09-25 10:16:46
*/
@Service
public class BusFormServiceImpl extends ServiceImpl<BusFormMapper, BusForm> implements BusFormService{
    @Resource
    public StocktakeService stocktakeService;

    @Resource
    private IFlowInstanceService FlowInstanceService;

    @Resource
    private SysUserOrgService sysUserOrgService;

    @Resource
    private InventorySummaryService inventorySummaryService;

    @Resource
    private InventorySummaryMapper inventorySummaryMapper;

    @Resource
    protected TaskService taskService;

    @Resource
    private BusFormRepository busFormRepository;

    public Object addEs() {
        List<BusForm> esDto=this.list();
        return busFormRepository.saveAll(esDto);
    }
    /**
     * 创建业务单
     * @param req
     * @return
     */
    @Override
    public String AddBussinessOrder(UpdateBusFormReq req) {
        //判断是否有工作流id，如果有则将状态进行修改
        if (ObjectUtil.isEmpty(req.getProcessDefinitionId()))
        {
            req.setExamineState("none");
        }
        else
        {
            req.setExamineState("working");
        }
        //判断该单据是否可以进行修改(如果审核中则不允许修改)
//        if (req.getExamineState().equals("working")){
//            throw new ServiceException(OrderExceptionEnum.ORDER_CAN_NOT_UPDATE);
//        }
        BusForm busForm = new BusForm();
        BeanUtil.copyProperties(req,busForm);
        //设置业务单的使用次数（默认是出库一次，入库一次）
        busForm.setUseCount("bothUsing");
        if (ObjectUtil.isNull(req.getId())){
            String id= UUID.randomUUID().toString();
            busForm.setId(id);
            //设置单据号（调拨的单号根据和登录人员的组织机构id有关）
            //根据userId去查询组织机构id
            OrderNum orderNum=new OrderNum();
            if (req.getBussinessType().equals("allocate")){
                if (req.getStartOrgId() == req.getOrgId()){
                    orderNum = stocktakeService.setOrderCode(req.getBussinessType(), req.getStartOrgId());
                } else {
                    orderNum = stocktakeService.setOrderCode(req.getBussinessType(), req.getEndOrgId());
                }
            }else {
                orderNum = stocktakeService.setOrderCode(req.getBussinessType(), req.getOrgId());
            }
            String codeValue=String.format("%04d",orderNum.getNum());
            busForm.setBussinessCode(orderNum.getBussinessType()+orderNum.getYear()+
                    String.format("%02d",LocalDateTime.now().getMonth().getValue())+
                    String.format("%02d",LocalDateTime.now().getDayOfMonth())+codeValue);

            busForm.setCreateTime(DateTimeUtil.getCurrentDateTime());
        }
        String processInstanceId=null;
        StartProcessInstanceDTO startProcessInstanceDTO=new StartProcessInstanceDTO();
        //执行工作流
        if (req.getExamineState().equals("working"))
        {
            startProcessInstanceDTO=new StartProcessInstanceDTO();
            startProcessInstanceDTO.setProcessDefinitionId(req.getProcessDefinitionId());
            startProcessInstanceDTO.setOrderId(busForm.getId());
            startProcessInstanceDTO.setOrderType("bussinessOrder");
            startProcessInstanceDTO.setUserId(req.getApplyUserId());
            //发物单位和收物单位
            if (req.getBussinessType().equals("use")){
                startProcessInstanceDTO.setStartOrgName(req.getOrgName());
            } else if (req.getBussinessType().equals("purchase")) {
                startProcessInstanceDTO.setStartOrgName(req.getSupplierName());
                startProcessInstanceDTO.setEndOrgName(req.getOrgName());
            } else if (req.getBussinessType().equals("allocate")) {
                startProcessInstanceDTO.setStartOrgName(req.getStartOrgName());
                startProcessInstanceDTO.setEndOrgName(req.getEndOrgName());
            } else if (req.getBussinessType().equals("repair")) {
                startProcessInstanceDTO.setStartOrgName(req.getOrgName());
                startProcessInstanceDTO.setEndOrgName(req.getSupplierName());
            }
            else if (req.getBussinessType().equals("remove")) {
                startProcessInstanceDTO.setStartOrgName(req.getOrgName());
            }
            else if (req.getBussinessType().equals("destruction")) {
                startProcessInstanceDTO.setStartOrgName(req.getOrgName());
                startProcessInstanceDTO.setEndOrgName(req.getSupplierName());
            }
            //装备列表
            startProcessInstanceDTO.setInvList(req.getInvList());
            //业务类型
            startProcessInstanceDTO.setBussinessType(req.getBussinessType());
            processInstanceId= FlowInstanceService.startProcessInstanceById(startProcessInstanceDTO);

        }
        //判断当前审核是否跳过
        if (processInstanceId!=null && processInstanceId.substring(0,4).equals("skip") ){
            String substring = processInstanceId.substring(4);
            busForm.setProcessId(substring);
            if (ObjectUtil.isNotNull(req.getId()) && !req.getId().trim().isEmpty()) {
                updateById(busForm);
            } else {
                //保存
                this.save(busForm);
            }
            Task currentTask = taskService.createTaskQuery().processInstanceId(substring).singleResult();
            // 直接完成当前任务
            taskService.complete(currentTask.getId());
        }else if (processInstanceId!=null){
            busForm.setProcessId(processInstanceId);

            String assigns= FlowInstanceService.GetNextAssign(processInstanceId);//这里需要手动更新审核人信息
            busForm.setCurrentAssign(assigns);
            if (ObjectUtil.isNotNull(req.getId()) && !req.getId().trim().isEmpty()) {
                //已经是一个草稿，在点击提交的时候只需要更新即可，因为数据库中已经存在该单据
                updateById(busForm);
            } else {
                //保存
                this.save(busForm);
            }
        }else {
            if (ObjectUtil.isNotNull(req.getId()) && !req.getId().trim().isEmpty()) {
                //已经是一个草稿，在点击提交的时候只需要更新即可，因为数据库中已经存在该单据
                updateById(busForm);
            } else {
                //保存
                this.save(busForm);
            }
        }
        busFormRepository.save(busForm);
        return busForm.getId();
    }



    /**
     * 查询业务单，（可以根据业务单进行修改）
     * @param req
     * @return
     */
    @Override
    public PageResult<BusFormDto> showBussinessOrder(QueryBusFormReq req) {
        //(如果传其他不是数据库字段参数或者排序规则不是deac或者asc可能会出现错误)
        if (ObjectUtil.isNotNull(req.getColumn()) && !req.getColumn().trim().isEmpty() &&
                (req.getOrder().equalsIgnoreCase("asc")|| req.getOrder().equalsIgnoreCase("desc")) &&
                ObjectUtil.isNotNull(req.getOrder()) && !req.getOrder().trim().isEmpty()) {
            //修改字段，和数据库字段进行统一
            req.setColumn(req.getColumn().replaceAll("[A-Z]", "_$0").toLowerCase());
            req.setOrder(req.getOrder().toLowerCase());
        }
        LambdaQueryWrapper<BusForm> eq = createWrapper(req);
        long size = list(eq).size();
        Page<BusForm> page = page(PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize()), eq);
        List<BusFormDto> collect = page.getRecords().stream().map(busForm -> {
            BusFormDto busFormDto = new BusFormDto();
            BeanPlusUtil.copyProperties(busForm, busFormDto);
            return busFormDto;
        }).collect(Collectors.toList());
        //余数
        long num= size % 10;
        //整数
        long integer=size / 10;
        List<BusFormDto> collect1=new ArrayList<>();
        if (num!=0){
            //判断整数是什么，就在第几页进行补
            if(req.getPageNo()-1==integer){
                for (int i = 0; i < 10-num; i++) {
                    BusFormDto busFormDto = new BusFormDto();
                    collect1.add(busFormDto);
                }
            }
            collect.addAll(collect1);
        }

        Page<BusFormDto> page1=new Page<>(req.getPageNo(),req.getPageSize());
        page1.setRecords(collect);
        page1.setTotal(size);
        return PageResultFactory.createPageResult(page1);
    }


    //根据调拨单，一键生成采购单
    @Override
    public List<GeneratePurchaseQuicklyDto> GeneratePurchaseQuickly(GeneratePurchaseQuicklyReq req) {
        //先把所有发物单位是自己的业务单全部查询出来，然后一一进行比较到底那个是前端传递的数据
//        List<BusForm> list = list(new LambdaQueryWrapper<BusForm>()
//                .eq(BusForm::getOrgId, req.getOrgId())
//                .eq(BusForm::getBussinessType, req.getBussinessType()));

        //将所有调拨单中的装备添加到totalList,之后进行去重并且相应数量相加
        List<BussinessOrderDetialReq> totalList=new ArrayList<>();
        //将所有调拨单获取
        List<UpdateBusFormReq> busFormList = req.getBusFormList();
        for (UpdateBusFormReq updateBusFormReq:busFormList) {
            String detailList = updateBusFormReq.getDetailList();
            List<BussinessOrderDetialReq> list = JSONObject.parseArray(detailList, BussinessOrderDetialReq.class);
            totalList.addAll(list);
        }
        //newList用来去重，把相同size和type的数量进行相加
        List<BussinessOrderDetialReq> newList=new ArrayList<>();
        for (BussinessOrderDetialReq item :totalList) {
            boolean found=false;
            if (newList.size()==0){
                newList.add(item);
                continue;
            }
            for (BussinessOrderDetialReq listItem:newList) {
                if (listItem.getSizeId().equals(item.getSizeId()) && listItem.getTypeId().equals(item.getTypeId())) {
                    // 如果存在匹配的元素，则更新 num 值
                    listItem.setPlanNum(listItem.getPlanNum() + item.getPlanNum());
                    found = true;
                    break;
                }
            }
            if (!found){
                newList.add(item);
            }
        }
        //创建list，返回给前端（只返回库存不足的装备和数量）
        List<GeneratePurchaseQuicklyDto> returnList=new ArrayList<>();
        //查询库存数量（将该组织机构下面的所有类型和号型的数量查询出来）
        List<InventorySummary> sumList = inventorySummaryMapper.selectByEqs(req.getOrgId());
        for (BussinessOrderDetialReq bussinessOrderDetial:newList) {
            boolean flag=false;
            for (InventorySummary inventorySummary:sumList) {
                if (bussinessOrderDetial.getSizeId().equals(inventorySummary.getSizeId())
                        && bussinessOrderDetial.getTypeId().equals(inventorySummary.getSizeId())){
                    //判断两个数量谁打谁小
                    if (bussinessOrderDetial.getPlanNum()-inventorySummary.getStockNumber()>0){
                        GeneratePurchaseQuicklyDto generatePurchaseQuicklyDto = new GeneratePurchaseQuicklyDto();
                        generatePurchaseQuicklyDto.setNumber(bussinessOrderDetial.getPlanNum()-inventorySummary.getStockNumber());
                        generatePurchaseQuicklyDto.setSizeId(bussinessOrderDetial.getSizeId());
                        generatePurchaseQuicklyDto.setSizeName(bussinessOrderDetial.getSizeName());
                        generatePurchaseQuicklyDto.setTypeId(bussinessOrderDetial.getTypeId());
                        generatePurchaseQuicklyDto.setTypeName(bussinessOrderDetial.getTypeName());
                        returnList.add(generatePurchaseQuicklyDto);
                    }
                    flag=true;
                    break;
                }

            }
            if (!flag){
                GeneratePurchaseQuicklyDto generatePurchaseQuicklyDto = new GeneratePurchaseQuicklyDto();
                generatePurchaseQuicklyDto.setNumber(bussinessOrderDetial.getPlanNum());
                generatePurchaseQuicklyDto.setSizeId(bussinessOrderDetial.getSizeId());
                generatePurchaseQuicklyDto.setSizeName(bussinessOrderDetial.getSizeName());
                generatePurchaseQuicklyDto.setTypeId(bussinessOrderDetial.getTypeId());
                generatePurchaseQuicklyDto.setTypeName(bussinessOrderDetial.getTypeName());
                returnList.add(generatePurchaseQuicklyDto);
            }
        }

        return returnList;
    }


    private LambdaQueryWrapper<BusForm> createWrapper(QueryBusFormReq req) {
        LambdaQueryWrapper<BusForm> eq = new LambdaQueryWrapper<BusForm>()
                //组织机构
                .eq(ObjectUtil.isNotNull(req.getOrgId()) && !req.getBussinessType().equals("allocate"),BusForm::getOrgId,req.getOrgId())

                //装备名称模糊查询
                .like(ObjectUtil.isNotNull(req.getTypeName()),BusForm::getInvList,req.getTypeName())
                //单号
                .like(ObjectUtil.isNotNull(req.getBussinessCode()),BusForm::getBussinessCode,req.getBussinessCode())
                //领用人
                .like(ObjectUtil.isNotNull(req.getReturnUser()),BusForm::getReturnUser,req.getReturnUser())
                //经办人
                .like(ObjectUtil.isNotNull(req.getAgent()),BusForm::getAgent,req.getAgent())
                //厂商名称
                .like(ObjectUtil.isNotNull(req.getSupplierName()),BusForm::getSupplierName,req.getSupplierName())
                //发物单位
                .like(ObjectUtil.isNotNull(req.getStartOrgName()),BusForm::getStartOrgName,req.getStartOrgName())
                //收物单位
                .like(ObjectUtil.isNotNull(req.getEndOrgName()),BusForm::getEndOrgName,req.getEndOrgName())
                //开始时间
                .ge(ObjectUtil.isNotNull(req.getStartTime()),BusForm::getCreateTime, req.getStartTime())
                //结束时间
                .le(ObjectUtil.isNotNull(req.getEndTime()),BusForm::getCreateTime, req.getEndTime())
                .last("order by " + req.getColumn() + " " + req.getOrder());

        //业务单据审核状态
        if (ObjectUtil.isNotNull(req.getExamineState()) && req.getExamineState().equals("unaudited")){

            List<String> examineStateList=new ArrayList<>();
            examineStateList.add("none");
            examineStateList.add("working");
            eq.in( BusForm::getExamineState,examineStateList);
        } else if (ObjectUtil.isNotNull(req.getExamineState()) && req.getExamineState().equals("finished")) {
            eq.eq(ObjectUtil.isNotNull(req.getExamineState() ) && !req.getExamineState().trim().isEmpty(), BusForm::getExamineState, req.getExamineState());
        }

        //报废、销毁的业务类型
        if (ObjectUtil.isNotNull(req.getBussinessType()) && req.getBussinessType().equals("both")){
            List<String> bussinessTypeList=new ArrayList<>();
            bussinessTypeList.add("remove");
            bussinessTypeList.add("destruction");
            eq.in( BusForm::getBussinessType,bussinessTypeList);
        }else {
            eq.eq(ObjectUtil.isNotNull(req.getBussinessType()) && !req.getBussinessType().trim().isEmpty(), BusForm::getBussinessType, req.getBussinessType());
        }

        if (ObjectUtil.isNotNull(req.getUserId())){
            //当前登录人
            eq.and(wrapper-> wrapper.eq(BusForm::getAgentId,req.getUserId()).or().eq(BusForm::getCurrentAssign,req.getUserId()));
        }
        if (req.getBussinessType().equals("allocate")){
            if (req.getStartOrgId()!=null){
                eq.eq(BusForm::getStartOrgId,req.getStartOrgId());
            }
            if (req.getEndOrgId()!=null){
                eq.eq(BusForm::getEndOrgId,req.getEndOrgId());
            }
            if (req.getStartOrgId()!=null && req.getEndOrgId()!=null){
                eq.and(wrapper-> wrapper.eq(BusForm::getStartOrgId,req.getOrgId()).or().eq(BusForm::getEndOrgId,req.getOrgId()));
            }
            eq.eq(ObjectUtil.isNotNull(req.getAllocateType()) && !req.getAllocateType().isEmpty(),BusForm::getAllocateType,req.getAllocateType());
        }

        return eq;
    }
}




