package com.junmp.jyzb.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.junmp.junmpProcess.dto.json.ChildNode;
import com.junmp.junmpProcess.utils.RabbitMQUtils2;
//import com.rabbitmq.client.Channel;
//import com.rabbitmq.client.Connection;
import com.junmp.jyzb.api.bean.dto.OrderDto;
import com.junmp.jyzb.api.bean.query.BussinessOrderDetialReq;
import com.junmp.jyzb.api.bean.query.OrderMainReq;
import com.junmp.jyzb.api.bean.req.UpdateBusFormReq;
import com.junmp.jyzb.api.bean.req.UpdateOrderDetailReq;
import com.junmp.jyzb.api.bean.req.UpdateOrderReq;
import com.junmp.jyzb.api.bean.req.UpdateReassignmentReq;
import com.junmp.jyzb.api.exception.enums.OrderExceptionEnum;
import com.junmp.jyzb.entity.*;
import com.junmp.jyzb.service.*;
import com.junmp.jyzb.utils.DateTimeUtil;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.MessageProperties;
import lombok.SneakyThrows;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEntityEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.impl.event.FlowableEntityEventImpl;
import org.flowable.engine.HistoryService;
import org.flowable.engine.delegate.event.AbstractFlowableEngineEventListener;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.variable.api.history.HistoricVariableInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;


@Component
    public class GlobalEndListener extends AbstractFlowableEngineEventListener {
    @Resource
    public OrderMainService orderMainService;

    @Resource
    public OrderDetailService orderDetailService;
    @Resource
    private HistoryService historyService;

    @Resource
    private BusFormService busFormService;

    @Resource
    private PolicemanService policemanService;
    @Resource
    private ReassignmentService reassignmentService;

    @Resource
    private StocktakeService stocktakeService;

        protected Logger logger = LoggerFactory.getLogger(this.getClass());

        @SneakyThrows
        @Override
        protected void processCompleted(FlowableEngineEntityEvent event) {

            if (event.getType() == FlowableEngineEventType.PROCESS_COMPLETED) {
                // 获取流程实例ID
                String processInstanceId = event.getProcessInstanceId();

                // 获取流程定义ID
                String processDefinitionId = event.getProcessDefinitionId();
                List<HistoricVariableInstance> orderType = historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstanceId).variableName("orderType").list();
                List<HistoricVariableInstance> bussinessType = historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstanceId).variableName("bussinessType").list();
                for (HistoricVariableInstance a:bussinessType) {
                    System.out.println("a = " + a);
                }

                if(orderType.size()>0) {


                    String Type= orderType.get(0).getValue().toString();
                    if (Type.equals("workOrder") || Type.equals("quickOrder"))//出入库单据(包含快速移库出库单)
                    {
//                        OrderMainReq req=new OrderMainReq();
//                        req.setProcessId(processInstanceId);
                        OrderMain existOrder= orderMainService.getOne(new LambdaQueryWrapper<OrderMain>()
                                .eq(OrderMain::getProcessId, processInstanceId));
                        existOrder.setExamineState("finished");
                        existOrder.setOrderState("ready");
                        UpdateOrderReq updateOrderReq = new UpdateOrderReq();
                        BeanPlusUtil.copyProperties(existOrder,updateOrderReq);
                        List<OrderDetail> list = orderDetailService.list(new LambdaQueryWrapper<OrderDetail>()
                                .eq(OrderDetail::getOrderId, updateOrderReq.getId()));
                        updateOrderReq.setId(existOrder.getId());
                        orderMainService.updateById(existOrder);
//                        orderMainService.ChangeOrderState(updateOrderReq);
                        List<UpdateOrderDetailReq> collect = list.stream().map(orderDetail -> {
                            UpdateOrderDetailReq updateOrderDetailReq = new UpdateOrderDetailReq();
                            BeanPlusUtil.copyProperties(orderDetail, updateOrderDetailReq);
                            return updateOrderDetailReq;
                        }).collect(Collectors.toList());
                        updateOrderReq.setDetailList(collect);
                        //将单据上传到rabbitmq
                        orderMainService.AddFinishOrder(updateOrderReq);
                    }
                    //业务单据
                    if (Type.equals("bussinessOrder")){
                        BusForm busForm = busFormService.getOne(new LambdaQueryWrapper<BusForm>()
                                .eq(BusForm::getProcessId, processInstanceId));
                        busForm.setExamineState("finished");
                        if (busForm.getBussinessType().equals("remove")){
                            String detailList = busForm.getDetailList();
                            List<BussinessOrderDetialReq> list = JSON.parseArray(detailList, BussinessOrderDetialReq.class);
                            for (BussinessOrderDetialReq bussinessOrderDetialReq:list) {
                                //如果数量相同则直接将全部在库数的装备表中的该仓库的装备状态全部设置为报废，并且修改库存汇总表中的数据
                                if (bussinessOrderDetialReq.getPlanNum()==bussinessOrderDetialReq.getStockNumber()){
                                    
                                }else {//如果数量不相等，状态不进行修改，只修改库存汇总表中的信息

                                }
                            }
                        }
                        busFormService.updateById(busForm);
                    }
                    if (Type.equals("reassigment")){//调岗申请单
                        Reassignment one = reassignmentService.getOne(new LambdaQueryWrapper<Reassignment>()
                                .eq(Reassignment::getProcessId, processInstanceId));
                        UpdateReassignmentReq updateReassignmentReq = new UpdateReassignmentReq();
                        BeanPlusUtil.copyProperties(one,updateReassignmentReq);
                        updateReassignmentReq.setExamineState("finished");
                        policemanService.changePoliceOrg(updateReassignmentReq);
                    }
                    if (Type.equals("stocktakeOrder")){//盘库申请单

                    }

                }

            }
        }

    // 获取流程实例关联的变量
    private Map<String, Object> getProcessVariables(String processInstanceId) {
        // 根据 processInstanceId 获取流程实例关联的变量
        // 这里需要根据你的业务逻辑来实现获取变量的方法
        // 返回一个包含流程变量的 Map
        return  null;
    }
    }

