package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;

/**
 * 
 * @TableName base_bus_form
 */
@TableName(value ="bussiness_bus_form")
@Data
@AllArgsConstructor
@NoArgsConstructor
@Document(indexName = "busform")
@JsonIgnoreProperties(ignoreUnknown = true)
public class BusForm implements Serializable {
    /**
     * id
     */
    @TableId(value = "id",type = IdType.ASSIGN_UUID)
    @Id
    private String id;

    /**
     * 工作流id
     */
    @TableField(value = "process_id")
    private String processId;

    /**
     * 单据业务类型
     */
    @TableField(value = "bussiness_type")
    private String bussinessType;

    /**
     * 单据编号
     */
    @TableField(value = "bussiness_code")
    private String bussinessCode;

    /**
     * 组织机构id
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 组织机构名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 发物单位id
     */
    @TableField(value = "start_org_id")
    private Long startOrgId;

    /**
     * 发物单位
     */
    @TableField(value = "start_org_name")
    private String startOrgName;
    /**
     * 收物单位id
     */
    @TableField(value = "end_org_id")
    private Long endOrgId;

    /**
     * 收物单位
     */
    @TableField(value = "end_org_name")
    private String endOrgName;

    /**
     * 审核状态
     */
    @TableField(value = "examine_state")
    private String examineState;

    /**
     * 价格
     */
    @TableField(value = "price")
    private BigDecimal price;

    /**
     * 数量
     */
    @TableField(value = "inventory_quantity")
    private Integer inventoryQuantity;

    /**
     * 附件地址
     */
    @TableField(value = "attachment_location")
    private String attachmentLocation;
    /**
     * 经办人id
     */
    @TableField(value = "agent_id")
    private String agentId;

    /**
     * 经办人
     */
    @TableField(value = "agent")
    private String agent;

    /**
     * 归还人id
     */
    @TableField(value = "return_user_id")
    private String returnUserId;

    /**
     * 归还人
     */
    @TableField(value = "return_user")
    private String returnUser;

    /**
     * 归还日期
     */
    @TableField(value = "return_date")
    private Date returnDate;

    /**
     * 申请时间
     */
    @TableField(value = "apply_time")
    private Date applyTime;


    /**
     * 调拨类型（2支拨，1价拨）
     */
    @TableField(value = "allocate_type")
    private String allocateType;

    /**
     * 备注
     */
    private String note;

    /**
     * 厂商id
     */
    @TableField(value = "supplier_id")
    private String supplierId;

    /**
     * 厂商名称
     */
    @TableField(value = "supplier_name")
    private String supplierName;
    /**
     * 厂商类型（0为供应商，1为生产厂商，2为维修单位，3为销毁单位）
     */
    @TableField(value = "agency_type")
    private Integer agencyType;

    /**
     * 装备类别拼接
     */
    @TableField(value = "inv_list")
    private String invList;
    /**
     * 仓库id
     */
    @TableField(value = "warehouse_id")
    private String warehouseId;

    /**
     * 装备详情
     */
    @TableField(value = "detail_list")
    private String detailList;

    /**
     * 创建时间
     */
    @TableField(value = "create_time",fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(value = "update_time",fill = FieldFill.UPDATE)
    private Date updateTime;

    /**
     * 创建人
     */
    @TableField(value = "create_user")
    private String createUser;

    /**
     * 更新人
     */
    @TableField(value = "update_user")
    private String updateUser;

    /**
     * 报废销毁类型（1销毁出库，2移入报废区）
     */
    private Integer type;

    /**
     * 审核人信息
     */
    @TableField(value = "current_assign")
    private String currentAssign;

    /**
     * 单据使用次数（forbidden禁止使用，outgoing 仅出库使用，incoming仅入库使用，bothuseing出入库都可以使用一次）
     */
    @TableField(value = "use_count")
    private String useCount;

    private static final long serialVersionUID = 1L;

}