package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.query.ProcessReq.PoliceEquipmentReq;
import com.junmp.jyzb.api.bean.query.TestReq;
import com.junmp.jyzb.entity.InventorySummary;
import com.junmp.jyzb.entity.PoliceEquipment;
import com.junmp.jyzb.service.InventorySummaryService;
import com.junmp.jyzb.service.PoliceEquipmentService;
import com.junmp.jyzb.service.TestService;
import com.junmp.jyzb.utils.ResponseResult;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.common.util.BeanPlusUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

@RestController
@Slf4j
@RequestMapping("/api")
public class TestController {

    @Resource
    private TestService testService;
    @Resource
    private InventorySummaryService inventorySummaryService;

    @Resource
    private PoliceEquipmentService policeEquipmentService;

    @Resource
    private RabbitAdmin rabbitAdmin;
    @RequestMapping("/hello")
    public ResponseResult Hello(){
        return new ResponseResult(10000,"操作成功","hello");
    }

//    @PostMapping("/test")
//    public ApiRes<Boolean> test(@RequestBody RabbitMqOrderReq req){
//        return ApiRes.success(testService.test(req));
//    }


    @PostMapping("/hasConsumers")
    public ApiRes<Boolean> hasConsumers(@RequestBody TestReq req){
        Long execute = rabbitAdmin.getRabbitTemplate().execute(channel -> channel.consumerCount(req.getQueueName()));
        System.out.println("execute = " + execute);
        return ApiRes.success(execute>0L);
    }

    @PostMapping("addPoliceEqs")
    public ApiRes<Boolean> addPoliceEqs(@RequestBody PoliceEquipmentReq req){
        List<PoliceEquipment> collect = req.getList().stream().map(policeEquipmentReq -> {
            PoliceEquipment policeEquipment = new PoliceEquipment();
            BeanPlusUtil.copyProperties(policeEquipmentReq, policeEquipment);
            return policeEquipment;
        }).collect(Collectors.toList());
        return ApiRes.success(policeEquipmentService.saveBatch(collect));
    }
}
