package com.junmp.jyzb.api.bean.req;

import com.junmp.v2.common.bean.request.ValidationApi;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

@Data
public class UpdateSupplierReq {
    @NotBlank(message = "供应商主键不能为空", groups = {ValidationApi.edit.class, ValidationApi.delete.class, ValidationApi.detail.class})
    private String id;
    @NotBlank(message = "供应商不能为空", groups = {ValidationApi.edit.class, ValidationApi.add.class})
    private String name;
    @NotBlank(message = "供应商编码不能为空", groups = {ValidationApi.edit.class, ValidationApi.add.class})
    private String code;

    /**
     * 类型，（0为供应商，1为生产厂商，2为维修单位，3为销毁单位）
     */
    @NotNull(message = "类型不能为空", groups = {ValidationApi.edit.class, ValidationApi.add.class})
    private Integer agencyType;

    private String shortName;

    private String contacts;

    private String phone;

    @NotBlank(message = "状态不能为空", groups = {ValidationApi.updateStatus.class})
    private Integer state;
}
