package com.junmp.jyzb.utils;

import cn.hutool.core.util.ObjectUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.*;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ElasticsearchUtil<T> {
    private final RestHighLevelClient client;



    public ElasticsearchUtil(RestHighLevelClient client) {
        this.client = client;
    }

    public List<T> searchEntities(String typeName,String index, Integer pageNum, Integer pageSize,Integer type, String keyword, Class<T> entityClass) throws IOException {
        if (pageNum < 0) pageNum = 0;

        SearchRequest request = new SearchRequest(typeName);
        SearchSourceBuilder builder = new SearchSourceBuilder();

        builder.from(pageNum);
        builder.size(pageSize);

        MatchQueryBuilder matchQueryBuilder = QueryBuilders.matchQuery(index, keyword).operator(Operator.AND);
//        MatchQueryBuilder matchQueryBuilder2 = QueryBuilders.matchQuery(index+".pinyin", keyword).operator(Operator.AND);

        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.should(matchQueryBuilder);
//        boolQueryBuilder.should(matchQueryBuilder2);
        if (typeName.equals("orgName"))
        {
            builder.postFilter(new TermQueryBuilder("delFlag", 1));
        }
        if (ObjectUtil.isNotNull(type)){
            builder.postFilter(new TermQueryBuilder("type",type));
        }

        builder.query(boolQueryBuilder);
        builder.timeout(new TimeValue(60, TimeUnit.SECONDS));

        request.source(builder);
        SearchResponse searchResponse = client.search(request, RequestOptions.DEFAULT);

        List<T> entityList = new ArrayList<>();
        for (SearchHit documentFields : searchResponse.getHits().getHits()) {
            Map<String, Object> sourceAsMap = documentFields.getSourceAsMap();
            T entity = fromMap(sourceAsMap, entityClass);

            entityList.add(entity);
        }

        return entityList;
    }

    private T fromMap(Map<String, Object> sourceAsMap, Class<T> entityClass) {
        ObjectMapper objectMapper = new ObjectMapper(); // 使用 Jackson 库进行转换
        return objectMapper.convertValue(sourceAsMap, entityClass);
    }
}
