package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.junmpProcess.dto.StartProcessInstanceDTO;
import com.junmp.junmpProcess.service.IFlowInstanceService;
import com.junmp.jyzb.api.bean.dto.*;
import com.junmp.jyzb.api.bean.query.*;
import com.junmp.jyzb.api.bean.query.InAndOutRecordReq.OutInLogsReq;
import com.junmp.jyzb.api.bean.req.UpdateOrderDetailReq;
import com.junmp.jyzb.api.bean.req.UpdateOrderReq;
import com.junmp.jyzb.api.bean.vo.InOrderInfo;
import com.junmp.jyzb.api.exception.enums.CabinetExceptionEnum;
import com.junmp.jyzb.api.exception.enums.OrderExceptionEnum;
import com.junmp.jyzb.entity.*;
import com.junmp.jyzb.mapper.InventorySummaryMapper;
import com.junmp.jyzb.mapper.OrderMainMapper;
import com.junmp.jyzb.service.*;
import com.junmp.jyzb.utils.DateTimeUtil;
import com.junmp.jyzb.utils.RabbitMQSendMsg;
import com.junmp.jyzb.utils.RedisUtils;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.exception.enums.DefaultBizExceptionEnum;
import com.junmp.v2.common.util.BeanPlusUtil;
import com.junmp.v2.common.util.HttpServletUtil;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.db.api.factory.PageResultFactory;
import com.junmp.v2.db.api.page.PageResult;
import com.junmp.v2.dict.entity.SysDict;
import com.junmp.v2.dict.entity.SysDictItem;
import com.junmp.v2.dict.service.SysDictItemService;
import com.junmp.v2.dict.service.SysDictService;
import com.junmp.v2.office.api.OfficeExcelApi;
import com.junmp.v2.office.api.bean.ExcelExportParam;
import org.flowable.engine.TaskService;
import org.flowable.task.api.Task;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.core.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.management.remote.rmi._RMIConnection_Stub;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;


@Service
public class OrderMainServiceImpl extends ServiceImpl<OrderMainMapper, OrderMain> implements OrderMainService {

    @Resource
    private OrderDetailService orderDetailService;
    @Resource
    private RabbitTemplate rabbitTemplate;
    @Resource
    private RabbitAdmin rabbitAdmin;

    @Resource
    private OrderNumService orderNumService;

    @Resource
    private PubOrgService pubOrgService;

    @Resource
    private OrderMainMapper orderMainMapper;

    @Resource
    private SysDictItemService sysDictItemService;

    @Resource
    private OrderLogService orderLogService;
    @Resource
    private IFlowInstanceService FlowInstanceService;
    @Resource
    private OfficeExcelApi officeExcelApi;

    @Resource
    private InventorySummaryService inventorySummaryService;

    @Resource
    private InventoryService inventoryService;

    @Resource
    private WarehouseService warehouseService;
    @Resource
    private BusFormService busFormService;

    @Resource
    private StocktakeService stocktakeService;

    @Resource
    private ReassignmentService reassignmentService;

    @Resource
    private PoliceEquipmentService policeEquipmentService;

    @Resource
    private SysDictService sysDictService;

    @Resource
    protected TaskService taskService;


    @Resource
    private InventorySummaryMapper inventorySummaryMapper;
    @Autowired
    private RabbitMQSendMsg MQ;


    @Transactional(rollbackFor = Exception.class)
    @Override
    public List<String> AddOrder(UpdateOrderReq req) {
        //修改单据使用次数状态，判断数据库是否有该单据，如果有，那么就判断当前单号是否一致，如果不一致，修改单据使用次数
        Long orgId;
        if (ObjectUtil.isNotNull(req.getId())){
            OrderMain one = orderMainExist(req.getId());
            if (ObjectUtil.isNotNull(one.getBussinessCode()) && ObjectUtil.isNotNull(one.getBussinessCode())) {
                if (!one.getBussinessCode().equals(req.getBussinessCode())) {
                    if (req.getOrderType().equals("in")) {
                        orgId = req.getEndOrgId();
                    } else {
                        orgId = Long.parseLong(req.getStartOrgId());

                    }
                    //入参
                    BusForm one1 = setState1(orgId, req.getBussinessCode());
                    busFormService.updateById(one1);

                    //库存
                    BusForm one2 = setState2(orgId, one.getBussinessCode());
                    busFormService.updateById(one2);

                }
            }
            //入参不为空，库里为空
            else if (ObjectUtil.isNotNull(one.getBussinessCode()) && ObjectUtil.isNull(one.getBussinessCode())){
                //只需要改一条数据
                if (req.getOrderType().equals("in")){
                    orgId=req.getEndOrgId();

                }else {
                    orgId=Long.parseLong(req.getStartOrgId());

                }
                //入参
                BusForm one1 = setState1(orgId, req.getBussinessCode());
                busFormService.updateById(one1);
            }
            //入参为空，库里不为空
            else if (ObjectUtil.isNull(one.getBussinessCode()) && ObjectUtil.isNotNull(one.getBussinessCode())){
                //只需要改一条数据
                if (req.getOrderType().equals("in")){
                    orgId=req.getEndOrgId();

                }else {
                    orgId=Long.parseLong(req.getStartOrgId());
                }
                //库存
                BusForm one2 = setState2(orgId, one.getBussinessCode());
                busFormService.updateById(one2);
            }
        }else {
            if (ObjectUtil.isNotNull(req.getBussinessCode())){
                //只需要更改一条单据
                //只需要改一条数据
                if (req.getOrderType().equals("in")){
                    orgId=req.getEndOrgId();

                }else {
                    orgId=Long.parseLong(req.getStartOrgId());
                }
                //入参
                BusForm one1 = setState1(orgId, req.getBussinessCode());
                busFormService.updateById(one1);
            }
        }


        //判断是否有工作流id，如果有则将状态进行修改
        if (ObjectUtil.isEmpty(req.getProcessDefinitionId())) {
            req.setExamineState("none");
        } else {
            req.setExamineState("working");
        }
        //判断该单据是否可以进行修改(如果审核中则不允许修改)
        if (ObjectUtil.isNotNull(req.getProcessId()) && !req.getProcessId().trim().isEmpty()){
            throw new ServiceException(OrderExceptionEnum.ORDER_CAN_NOT_UPDATE);
        }
        OrderMain order = new OrderMain();
        BeanPlusUtil.copyProperties(req, order);
        //先判断该单据id是否存在，如果存在，进行更新操作即可
        if (ObjectUtil.isNotNull(req.getId()) && ! req.getId().trim().isEmpty()){
            //删除子单据
            orderDetailService.remove(new LambdaQueryWrapper<OrderDetail>()
                    .eq(ObjectUtil.isNotNull(req.getId()),OrderDetail::getOrderId,req.getId()));
        }else {
            //设置id
            String id=UUID.randomUUID().toString();
            order.setId(id);
            //设置单据单号
            OrderNum orderNum = setOrderCode(req);
            String codeValue=String.format("%04d",orderNum.getNum());
            order.setOrderCode(orderNum.getBussinessType()+orderNum.getYear()+
                    String.format("%02d",LocalDateTime.now().getMonth().getValue())+
                    String.format("%02d",LocalDateTime.now().getDayOfMonth())+codeValue);
        }

        //设置总价格和应出入库数量
        Integer sumNum=0;
        BigDecimal priceTotal=new BigDecimal(0);
        List<OrderDetail> detailList = new ArrayList<>();
        //通过遍历批量保存详细信息
        for (UpdateOrderDetailReq listReq:req.getDetailList()) {
            OrderDetail detail=new OrderDetail();
            BeanPlusUtil.copyProperties(listReq, detail);
            detail.setOrderId(order.getId());
            //设置单据类型
            detail.setType(order.getOrderType());
            //将数量和价格进行累加
            sumNum += detail.getPlanNum();
            priceTotal = priceTotal.add(BigDecimal.valueOf(detail.getPlanNum()).multiply(detail.getPrice())) ;
            detail.setCreateTime(DateTimeUtil.getCurrentDateTime());
            detailList.add(detail);
        }
        orderDetailService.saveBatch(detailList);
        //设置总价格和总数量
        order.setPrice(priceTotal);
        order.setInventoryQuantity(sumNum);
        order.setCreateTime(DateTimeUtil.getCurrentDateTime());
        //执行工作流
        String processInstanceId = null;
        StartProcessInstanceDTO startProcessInstanceDTO=new StartProcessInstanceDTO();
        //业务单走审核流
        startProcessInstanceDTO.setProcessDefinitionId(req.getProcessDefinitionId());
        startProcessInstanceDTO.setOrderId(order.getId());
        startProcessInstanceDTO.setUserId(req.getUserId());

        if (!req.getBussinessType().equals("quick") && req.getExamineState().equals("working"))//其他出入库单
        {
            startProcessInstanceDTO.setOrderType("workOrder");
            processInstanceId= FlowInstanceService.startProcessInstanceById(startProcessInstanceDTO);

        }else if (req.getBussinessType().equals("quick") && req.getExamineState().equals("working")){//快速移库单
            startProcessInstanceDTO.setOrderType("quickOrder");
            processInstanceId= FlowInstanceService.startProcessInstanceById(startProcessInstanceDTO);

        }
        //list返回数据
        List<String> list=new ArrayList<>();
        //当前审核是否跳过
        if (processInstanceId!=null && processInstanceId.substring(0,4).equals("skip") ){
            String substring = processInstanceId.substring(4);
            order.setProcessId(substring);
            if (ObjectUtil.isNotNull(req.getId()) && !req.getId().trim().isEmpty()) {
                updateById(order);
            } else {
                //保存
                this.save(order);
            }
            Task currentTask = taskService.createTaskQuery().processInstanceId(substring).singleResult();
            // 直接完成当前任务
            taskService.complete(currentTask.getId());
        }else {
            order.setProcessId(processInstanceId);
            if (ObjectUtil.isNotNull(req.getId()) && !req.getId().trim().isEmpty()) {
                updateById(order);
            } else {
                //保存
                this.save(order);
            }
        }
        list.add(order.getId());
        for (OrderDetail orderDetail:detailList) {
            list.add(Long.toString(orderDetail.getId()));
        }


        return list;
    }

    private BusForm setState2(Long orgId,String bussinessCode){
        BusForm busform = busFormService.getOne(new LambdaQueryWrapper<BusForm>()
                .eq(BusForm::getOrgId, orgId)
                .in(BusForm::getBussinessCode, bussinessCode));
        busform.setOrderCurrentState(busform.getOrderLastState());
        switch (busform.getOrderCurrentState()){

            case "none":
                busform.setOrderCurrentState("outgoing");
                break;
            case "incoming":
                busform.setOrderCurrentState("bothuseing");
                break;
            case "outgoing":
                busform.setOrderCurrentState("bothuseing");
                break;
        }
        return busform;
    }

    private BusForm setState1(Long orgId,String bussinessCode){
        BusForm busform = busFormService.getOne(new LambdaQueryWrapper<BusForm>()
                .eq(BusForm::getOrgId, orgId)
                .in(BusForm::getBussinessCode, bussinessCode));
        busform.setOrderCurrentState(busform.getOrderLastState());
        switch (busform.getOrderCurrentState()){
            case "bothuseing":
                busform.setOrderCurrentState("outgoing");
                break;
            case "incoming":
                busform.setOrderCurrentState("forbidden");
                break;
            case "outgoing":
                busform.setOrderCurrentState("forbidden");
                break;

        }
        return busform;
    }


    //设置单据单号（并且对order_num表进行新增或者更新）
    public OrderNum setOrderCode(UpdateOrderReq req){
        //设置采购单号，需要先判断该组织机构的采购单号是否存在，如果存在则将数量进行增加，如果不存在则新增一条对应的数据
        OrderNum orderNum = new OrderNum();
        //获取年,月，日，获取业务出入状态，获取组织机构id，获取业务类型
        orderNum.setYear(LocalDateTime.now().getYear());
        //将业务类型转为中文简写(CK出库，RK入库)
        Long sysDictId = sysDictService.getOne(new LambdaQueryWrapper<SysDict>()
                .eq(SysDict::getDictCode, "order_chinese_setting")).getDictId();
        String itemValue = sysDictItemService.getOne(new LambdaQueryWrapper<SysDictItem>()
                .eq(SysDictItem::getItemText, req.getOrderType())
                .eq(SysDictItem::getDictId,sysDictId)).getItemValue();
        orderNum.setBussinessType(itemValue);
        //出入业务状态
        orderNum.setOutInType(req.getOrderType());
        //判断是出库还是入库，出库为发物单位，入库为收物单位
        OrderNum one = new OrderNum();
        if (req.getOrderType().equals("in")){
            orderNum.setEndOrgId(req.getEndOrgId());
            one = orderNumService.getOne(new LambdaQueryWrapper<OrderNum>()
                    .eq(OrderNum::getEndOrgId, orderNum.getEndOrgId())
                    .eq(OrderNum::getBussinessType, orderNum.getBussinessType())
                    .eq(OrderNum::getYear, orderNum.getYear())
                    .eq(OrderNum::getOutInType, orderNum.getOutInType()));
        }else {
            orderNum.setStartOrgId(Long.valueOf(req.getStartOrgId()));
            one = orderNumService.getOne(new LambdaQueryWrapper<OrderNum>()
                    .eq(OrderNum::getStartOrgId, orderNum.getStartOrgId())
                    .eq(OrderNum::getBussinessType,orderNum.getBussinessType())
                    .eq(OrderNum::getYear, orderNum.getYear())
                    .eq(OrderNum::getOutInType, orderNum.getOutInType()));
        }
        
        //设置num的数量
        if (ObjectUtil.isNull(one)){
            orderNum.setNum(1);
            orderNumService.save(orderNum);
            return orderNum;
        }else {
            one.setNum(one.getNum()+1);
            orderNumService.updateById(one);
            return one;
        }

    }



    //新增默认审核通过的任务单（可以没有工作流）
    @Transactional(rollbackFor = Exception.class)
    @Override
    public String AddFinishOrder(UpdateOrderReq req) {

        //添加到数据库中(如果该单据没有审批流，那么就直接存入数据库)
        if (ObjectUtil.isNull(req.getProcessDefinitionId()) && ObjectUtil.isNull(req.getProcessId())){
            List<String> strings = AddOrder(req);
            OrderMain orderMain = getById(strings.get(0));
            List<OrderDetail> list = orderDetailService.list(new LambdaQueryWrapper<OrderDetail>()
                    .eq(OrderDetail::getOrderId, strings.get(0)));
            BeanPlusUtil.copyProperties(orderMain,req);
            req.setExamineState("finished");
            orderMain.setExamineState("finished");
            updateById(orderMain);
            List<UpdateOrderDetailReq> collect = list.stream().map(orderDetail -> {
                UpdateOrderDetailReq orderDetailReq = new UpdateOrderDetailReq();
                BeanPlusUtil.copyProperties(orderDetail, orderDetailReq);
                return orderDetailReq;
            }).collect(Collectors.toList());
            req.setDetailList(collect);

        }

        //单据类型，分发单据
        req.setApi("DistributeOrder");
        //将完成的任务单直接推送到消息队列rabbitmq中（需要判断是入库单还是出库单，入库单传发物单位id，出库单传收物单位id）
        //方法2：一个交换机，多个队列。动态创建队列
        String exchangeName="orderExchange";
        //需要判断是入库单还是出库单，入库单传收物单位id，出库单传发物单位id
        if(req.getOrderType().equals("in")){
            MQ.SendMsg(exchangeName,req.getEndOrgId().toString(),req);
        }else {
            MQ.SendMsg(exchangeName,req.getStartOrgId().toString(),req);
        }
        return req.getId();
    }


    //更新任务单（进入工作流中之后不能进行更改）
//    @Transactional(rollbackFor = Exception.class)
//    @Override
//    public Boolean  updateOrder(UpdateOrderReq req) {
//        OrderMain order = orderMainExist(req.getId());
//        if (!order.getExamineState().equals("none"))
//        {
//            throw new ServiceException(OrderExceptionEnum.ORDER_CAN_NOT_UPDATE);
//        }
//        //（直接删除并重新插入数据）----------------------------------------------
//        orderDetailService.remove(new LambdaQueryWrapper<OrderDetail>().eq(OrderDetail::getOrderId, req.getId()));
//        Integer sumNum=0;
//        BigDecimal priceTotal=new BigDecimal(0);
//        List<OrderDetail> detailList = new ArrayList<>();
//        for (UpdateOrderDetailReq listReq:req.getDetailList()) {
//            OrderDetail detail=new OrderDetail();
//            BeanPlusUtil.copyProperties(listReq, detail);
//            detail.setOrderId(order.getId());
//            //设置单据类型
//            detail.setType(order.getOrderType());
//            //将数量和价格进行累加
//            sumNum += detail.getPlanNum();
//            priceTotal = priceTotal.add(BigDecimal.valueOf(detail.getPlanNum()).multiply(detail.getPrice())) ;
//            detail.setCreateTime(DateTimeUtil.getCurrentDateTime());
//            detailList.add(detail);
//        }
//        orderDetailService.saveBatch(detailList);
//        //设置总价格和总数量
//        order.setPrice(priceTotal);
//        order.setInventoryQuantity(sumNum);
//        order.setCreateTime(DateTimeUtil.getCurrentDateTime());
//        return this.updateById(order);
//    }
//

    //更新任务单（进入工作流中之后不能进行更改）
    @Transactional(rollbackFor = Exception.class)
    @Override
    public Boolean  ChangeOrderState(UpdateOrderReq req) {
        OrderMain order = orderMainExist(req.getId());

        order.setExamineState(req.getExamineState());
        order.setOrderState(req.getOrderState());
        return this.updateById(order);
    }
    public boolean hasCommonElements(List<?> list1, List<?> list2) {
        for (Object item1 : list1) {
            if (list2.contains(item1)) {
                return true; // 找到相同值
            }
        }
        return false; // 没有相同值
    }

    //查询任务列表(根据组织机构id)
    @Override
    public PageResult<OrderMainDto> getOrderPage(OrderMainReq req) {
        Page<OrderMain> page = new Page<>();
        //排序字段处理，将驼峰改成和数据库同步的字段名(如果传其他不是数据库字段参数或者排序规则不是deac或者asc可能会出现错误)
        if (ObjectUtil.isNotNull(req.getColumn()) && !req.getColumn().trim().isEmpty() &&
                (req.getOrder().equalsIgnoreCase("asc")|| req.getOrder().equalsIgnoreCase("desc")) &&
                ObjectUtil.isNotNull(req.getOrder()) &&!req.getOrder().trim().isEmpty()) {
            //修改字段，和数据库字段进行统一
            req.setColumn(req.getColumn().replaceAll("[A-Z]", "_$0").toLowerCase());
            req.setOrder(req.getOrder().toLowerCase());
        }
        //根据查询条件得到单据
        
        IPage<OrderMain> outOrderPage = orderMainMapper.getOrderPage(PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize()),req);
        page.setRecords(outOrderPage.getRecords());
        page.setTotal(outOrderPage.getTotal());

        List<OrderMainDto> orderMainDtoList = page.getRecords().stream().map(orderMain -> {
            OrderMainDto orderMainDto = new OrderMainDto();
            BeanPlusUtil.copyProperties(orderMain,orderMainDto);
            return orderMainDto;
        }).collect(Collectors.toList());
        Page<OrderMainDto> page1 = PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize());
        page1.setTotal(page.getTotal());
        page1.setRecords(orderMainDtoList);
        return PageResultFactory.createPageResult(page1);
    }



    //根据任务单id查看业务明细
    @Override
    public OrderDto GetDetailById(OrderMainReq req) {
        //判断任务单是否存在
        OrderMain orderMain = orderMainExist(req.getId());
        OrderDto orderDto = new OrderDto();
        BeanPlusUtil.copyProperties(orderMain,orderDto);
        List<OrderDetail> list=new ArrayList<>();
        //排序字段处理，将驼峰改成和数据库同步的字段名
        //将详细信息存入列表属性中
        //通过任务单id查询对应的详细信息
        if (ObjectUtil.isNotNull(req.getColumn()) && !req.getColumn().trim().isEmpty() &&
                (req.getOrder().equalsIgnoreCase("asc")|| req.getOrder().equalsIgnoreCase("desc")) && !req.getOrder().trim().isEmpty()) {
            //修改字段，和数据库字段进行统一
            req.setColumn(req.getColumn().replaceAll("[A-Z]", "_$0").toLowerCase());
            list=orderDetailService.list(new LambdaQueryWrapper<OrderDetail>()
                    .eq(OrderDetail::getOrderId, req.getId())
                    .last("order by "+req.getColumn() +" "+req.getOrder()));

        } else {
            list = orderDetailService.list(new LambdaQueryWrapper<OrderDetail>()
                    .eq(OrderDetail::getOrderId, req.getId())
                    .orderByDesc(OrderDetail::getCreateTime));
        }
        List<OrderDetailDto> orderDetailDtoList=new ArrayList<>();
        for (OrderDetail orderDetail:list) {
            OrderDetailDto orderDetailDto = new OrderDetailDto();

            BeanPlusUtil.copyProperties(orderDetail,orderDetailDto);
            orderDetailDtoList.add(orderDetailDto);
        }
        orderDto.setDetailList(orderDetailDtoList);
        return orderDto;
    }

    //单据状态上报
    @Override
    public boolean PushState(OrderUploadReq req) {
        OrderMain orderMain = orderMainExist(req.getId());
        //获取单据的出入库，获取发物单位id或者收物单位id
        String orderType = orderMain.getOrderType();
        String exchangeName="OrderStateExchange";
        //推送到rabbitmq中去
        if (orderType.equals("in")){
            Long endOrgId = orderMain.getEndOrgId();
            Queue queue=new Queue(Long.toString(endOrgId),true,false,false);
            Exchange exchange = new DirectExchange(exchangeName, true, false);
            rabbitAdmin.declareQueue(queue);
            rabbitAdmin.declareExchange(exchange);
            rabbitAdmin.declareBinding(BindingBuilder.bind(queue).to(exchange).with(Long.toString(endOrgId)).noargs());
            rabbitTemplate.convertAndSend(exchangeName, Long.toString(endOrgId), req);

        }else {
            Long startOrgId = orderMain.getStartOrgId();
            Queue queue = new Queue(Long.toString(startOrgId), true, false, false);
            Exchange exchange = new DirectExchange(exchangeName, true, false);
            rabbitAdmin.declareQueue(queue);
            rabbitAdmin.declareExchange(exchange);
            rabbitAdmin.declareBinding(BindingBuilder.bind(queue).to(exchange).with(Long.toString(startOrgId)).noargs());
            rabbitTemplate.convertAndSend(exchangeName, Long.toString(startOrgId), req);
        }
        return true;
    }

    //（只对summary表进行操作）
    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean Accounting(UpdateOrderReq req) {
        //判断传递的订单主id是否存在
        OrderMain orderMain = orderMainExist(req.getId());
        //记账子单据不能传空
        if (req.getDetailList().size()==0){
            throw new ServiceException(OrderExceptionEnum.ORDERDETAIL_ISNOT_NULL);
        }
        //前端传递的子单数据
        List<UpdateOrderDetailReq> reqList = req.getDetailList();
        //将记账数量进行相加
        Integer updateQuantity=0;
        //将价格进行添加修改
        BigDecimal priceTotal=new BigDecimal(0);
        //获取子单据
        List<OrderDetail> list = orderDetailService.list(new LambdaQueryWrapper<OrderDetail>()
                .eq(OrderDetail::getOrderId,req.getId()));
        //获取所有传递的子单据id
        Set<Long> collect = req.getDetailList().stream().map(UpdateOrderDetailReq::getId).collect(Collectors.toSet());
        //获取所有数据库的子单据id
        Set<Long> existingIds = list.stream().map(OrderDetail::getId).collect(Collectors.toSet());
        //创建一个操作记录(用于在记账log表中记录)
//        StringBuilder stringBuilder = new StringBuilder();
        //存放更新数据库中的子单据
        List<OrderDetail> orderDetailList=new ArrayList<>();
        //创建一个列表用于修改summary数据库表中数据。
        List<UpdateOrderDetailReq> orderDetailReqList=new ArrayList<>();
        List<AccountingDto> accountingDtoList=new ArrayList<>();
        //比较两个子单id完全一致,判断传递的子单据id在数据库中是否存在，如果不存在则抛出子单据不存在异常
        if (collect.size() == existingIds.size() && collect.containsAll(existingIds) && existingIds.containsAll(collect)){
            for (UpdateOrderDetailReq uploadDetailReq : reqList) {
                OrderDetail orderDetail = new OrderDetail();
                BeanPlusUtil.copyProperties(uploadDetailReq,orderDetail);
                //获取修改后的数量并且记录(modifyQuantity表示有记账数量)
                if (uploadDetailReq.getModifyQuantity() >= 0 ){
//                    String log = "将"+uploadDetailReq.getTypeName()+"号型为"+
//                            uploadDetailReq.getSizeName()+"单价为"+uploadDetailReq.getPrice()+"的物资数量记为"+uploadDetailReq.getModifyQuantity()+";";
//                    stringBuilder.append(log);
                    AccountingDto accountingDto = new AccountingDto();
                    BeanPlusUtil.copyProperties(uploadDetailReq,accountingDto);
                    accountingDtoList.add(accountingDto);
                    //修改单子数量数据,价格
                    orderDetail.setModifyQuantity(uploadDetailReq.getModifyQuantity());
                    orderDetail.setUpdateTime(DateTimeUtil.getCurrentDateTime());
                    orderDetailList.add(orderDetail);
                    orderDetailReqList.add(uploadDetailReq);
                    //修改后数量
                    updateQuantity+=uploadDetailReq.getModifyQuantity();
                    priceTotal=priceTotal.add(BigDecimal.valueOf(uploadDetailReq.getModifyQuantity()).multiply(uploadDetailReq.getPrice()));
                }else {
                    throw new ServiceException(OrderExceptionEnum.ORDERDETAIL_ERROR);
                }
            }
        }else {
            throw new ServiceException(OrderExceptionEnum.ORDERDETAIL_ERROR);
        }
        //批量更新子单据数量
        boolean a=false;
        if (orderDetailList.size()!=0){
            a = orderDetailService.updateBatchById(orderDetailList);
        }
        //更新主单据的数量和价格
        orderMain.setActualQuantity(updateQuantity);
        orderMain.setPrice(priceTotal);
        orderMain.setOrderState("finished");
        //修改记账状态，0未记账，1已记账
        orderMain.setManualState(1);
        orderMain.setUpdateTime(DateTimeUtil.getCurrentDateTime());
        boolean b = updateById(orderMain);
        //将修改内容存储记录（历史操作，数量，单据，价格，组织机构）
        //创建记账操作记录并且记录到数据表order_log中
//        boolean b = saveAccountingLog(req, stringBuilder, updateQuantity);
        boolean c = saveAccountingLog(req, accountingDtoList, updateQuantity);

        //修改装备汇总表中的数据 inventory_summary
        Long orgId;
        if (orderMain.getOrderType().equals("in")){
            orgId=orderMain.getEndOrgId();
        }
        else {
            orgId=orderMain.getStartOrgId();
        }
        boolean d = updateSummaryInfo(req, orderDetailReqList, orgId);

        //如果是领用，警员绑定装备
        boolean e=true;
        if (req.getBussinessType().equals("use")){

            e = policeBindEqs(req, reqList, orgId);
        }
        //如果是快速移库，记账完成之后新增入库单并且该单据不走审核流，但是审核状态和入库状态显示已完成
        boolean f=true;
        if (req.getBussinessType().equals("quick")){
            f = addQuickOrder(orderMain);
        }
        //更新主单据
        return (a && b && c && d && e && f );
    }

    public boolean policeBindEqs(UpdateOrderReq req,List<UpdateOrderDetailReq> reqList,Long orgId){
        //如果是领用出库，那记账结束以后将装备挂到警员名下（存储到policemanEquipment表中）
        if (req.getBussinessType().equals("use")){
            List<PoliceEquipment> collect1 = reqList.stream().map(updateOrderDetailReq -> {
                PoliceEquipment policeEquipment = new PoliceEquipment();
                policeEquipment.setPoliceId(req.getReturnUserId());
                policeEquipment.setSizeId(updateOrderDetailReq.getSizeId());
                policeEquipment.setSizeName(updateOrderDetailReq.getSizeName());
                policeEquipment.setTypeId(updateOrderDetailReq.getTypeId());
                policeEquipment.setTypeName(updateOrderDetailReq.getTypeName());
                policeEquipment.setNum(updateOrderDetailReq.getModifyQuantity());
                policeEquipment.setOrgId(orgId);
                policeEquipment.setLocationId(updateOrderDetailReq.getWarehouseId());
                policeEquipment.setCreateTime(DateTimeUtil.getCurrentDateTime());
                return policeEquipment;
            }).collect(Collectors.toList());
            return policeEquipmentService.saveBatch(collect1);
        }else {
            return true;
        }
    }

    //将修改内容存储记录（历史操作，数量，单据，价格，组织机构）
    //创建记账操作记录并且记录到数据表order_log中
    public boolean saveAccountingLog (UpdateOrderReq req,List<AccountingDto> accountingDtoList,Integer updateQuantity){
        OrderLog orderLog = new OrderLog();
        BeanPlusUtil.copyProperties(req,orderLog);
        orderLog.setId(UUID.randomUUID().toString());
//        orderLog.setHistoryMsg(stringBuilder.toString());
        orderLog.setHistoryMsg(JSON.toJSONString(accountingDtoList));
        orderLog.setUpdateQuantity(updateQuantity);
        if (req.getOrderType().equals("in")){
            orderLog.setOrgId(req.getEndOrgId());
            orderLog.setOrgName(req.getEndOrgName());
        }else {
            orderLog.setOrgId(Long.parseLong(req.getStartOrgId()));
            orderLog.setOrgName(req.getStartOrgName());
        }
        orderLog.setOrderId(req.getId());
        orderLog.setCreateTime(DateTimeUtil.getCurrentDateTime());
        //将记账记录保存
        return orderLogService.save(orderLog);
    }

    //修改装备汇总表中的数据inventory_summary
    public boolean updateSummaryInfo(UpdateOrderReq req,List<UpdateOrderDetailReq> orderDetailReqList,Long orgId){
        //将库存summary表中数据进行查询出来一一进行比较，如果说sizeId，typeId，warehouseId相同则对该数据进行修改，如果说该数据不存在的话则在summary表中添加一条数据
        List<Object[]> searchCriteria=new ArrayList<>();
        for (UpdateOrderDetailReq upReq: orderDetailReqList) {
            Object[] criteria=new Object[]{orgId,upReq.getWarehouseId(),upReq.getTypeId(),upReq.getSizeId(),upReq.getPrice()};
            searchCriteria.add(criteria);
        }
        List<InventorySummary> inventorySummaryList = inventorySummaryMapper.selectSumByItems(searchCriteria);
        List<InventorySummary> addList=new ArrayList<>();
        List<InventorySummary> updateList=new ArrayList<>();
        for (UpdateOrderDetailReq upReq: orderDetailReqList) {
            boolean flag=false;
            for (InventorySummary is:inventorySummaryList) {
                if (upReq.getWarehouseId().equals(is.getLocationId()) && upReq.getSizeId().equals(is.getSizeId())
                        && upReq.getTypeId().equals(is.getTypeId()) && upReq.getPrice().compareTo(is.getUnitPrice())==0){
                    //修改各种数量和价格
                    if (req.getOrderType().equals("in")){//入库没有关系
                        is.setOutboundNumber(is.getOutboundNumber()-upReq.getModifyQuantity());
                        is.setStockNumber(is.getStockNumber()+upReq.getModifyQuantity());
                        is.setPrice(is.getPrice().add(BigDecimal.valueOf(upReq.getModifyQuantity()).multiply(upReq.getPrice())) );
                    }else if (req.getOrderType().equals("out") && req.getBussinessType().equals("destruction")){//销毁出库直接减库存，减金额
                        is.setPrice(is.getPrice().subtract(BigDecimal.valueOf(upReq.getModifyQuantity()).multiply(upReq.getPrice())));
                        is.setNumber(is.getNumber()-upReq.getModifyQuantity());
                        is.setDestructionNumber(is.getDestructionNumber()+upReq.getModifyQuantity());
                    }else {//其他出库就直接正常计算
                        is.setOutboundNumber(is.getOutboundNumber()+upReq.getModifyQuantity());
                        is.setStockNumber(is.getStockNumber()-upReq.getModifyQuantity());
                        is.setPrice(is.getPrice().subtract(BigDecimal.valueOf(upReq.getModifyQuantity()).multiply(upReq.getPrice())) );
                    }
                    updateList.add(is);
                    flag=true;
                    break;
                }
            }
            //表示库存中没有，那么插入数据
            if (!flag){
                InventorySummary inventorySummary = new InventorySummary();
                inventorySummary.setUnitPrice(upReq.getPrice());
                inventorySummary.setPrice(BigDecimal.valueOf(upReq.getModifyQuantity()).multiply(upReq.getPrice()));
                inventorySummary.setBrokenNumber(0);
                inventorySummary.setExpireNumber(0);
                inventorySummary.setDestructionNumber(0);
                inventorySummary.setNearBrokenNumber(0);
                inventorySummary.setCreateTime(DateTimeUtil.getCurrentDateTime());
                if (req.getOrderType().equals("in")){
                    inventorySummary.setOutboundNumber(0);
                    inventorySummary.setUseNumber(0);
                    inventorySummary.setStockNumber(upReq.getModifyQuantity());
                }
                addList.add(inventorySummary);
            }
        }

        boolean a=true;
        if (addList.size()>0){
            boolean b = inventorySummaryService.saveBatch(addList);
            a = b;
        }
        if (updateList.size()>0){
            boolean b = inventorySummaryService.updateBatchById(updateList);
            a = a && b;
        }
        return a;

    }

    /**
     * 查看记账列表
     * @param req
     * @return
     */
    @Override
    public PageResult<OrderLog> ShowAccountingPage(QueryOrderLogReq req) {
        LambdaQueryWrapper<OrderLog> eq = new LambdaQueryWrapper<OrderLog>()
                .eq(ObjectUtil.isNotNull(req.getBussinessType()), OrderLog::getBussinessType, req.getBussinessType())
                .eq(ObjectUtil.isNotNull(req.getOrderType()), OrderLog::getOrderType, req.getOrderType())
                .eq(ObjectUtil.isNotNull(req.getOrderId()), OrderLog::getOrgId, req.getOrgId())
                .ge(ObjectUtil.isNotNull(req.getStartTime()), OrderLog::getCreateTime, req.getStartTime())
                .le(ObjectUtil.isNotNull(req.getEndTime()), OrderLog::getCreateTime, req.getEndTime());
        Page<OrderLog> page = orderLogService.page(PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize()), eq);
        return PageResultFactory.createPageResult(page);
    }


    /**
     * 入库单导出功能
     * @param req
     */
    @Override
    public void InOrderExport(OrderMainReq req) {
        LambdaQueryWrapper<OrderMain> wrapper = createWrapper(req);
        List<InOrderInfo> collect = list(wrapper).stream().map(orderMain -> {
            InOrderInfo inOrderInfo = new InOrderInfo();
            BeanPlusUtil.copyProperties(orderMain, inOrderInfo);
            //装备名称
            String inventoryName = "";
            List<OrderDetail> orderDetailList = orderDetailService.QueryList(orderMain.getId());
            for (OrderDetail orderDetail : orderDetailList) {
                inventoryName = inventoryName + orderDetail.getTypeName() + "/";
            }
            String substring = inventoryName.substring(0, inventoryName.length() - 1);
            inOrderInfo.setInventoryName(substring);
            //查询字典表设置入库类型
//            List<SysDictItem> list = sysDictItemService.list(new LambdaQueryWrapper<SysDictItem>()
//                    .eq(SysDictItem::getItemValue, orderMain.getBussinessType()));
////            inOrderInfo.setOrderType(itemText);
//            System.out.println("list = " + list);
            return inOrderInfo;

        }).collect(Collectors.toList());
        //设置导出的单据序号
        for (int i = 1; i <= collect.size() ; i++) {
            collect.get(i-1).setNumId(i);
        }
        HttpServletResponse response = HttpServletUtil.getResponse();
        ExcelExportParam param = new ExcelExportParam();
        param.setDataList(collect);
        param.setClazz(InOrderInfo.class);
        param.setResponse(response);
        param.setFileName("入库单据列表.xls");
        //对数据进行导出
        officeExcelApi.easyExportDownload(param);

    }

    @Override
    public void OutOrderExport(OrderMainReq req) {
        LambdaQueryWrapper<OrderMain> wrapper = createWrapper(req);
        List<InOrderInfo> collect = list(wrapper).stream().map(orderMain -> {
            InOrderInfo inOrderInfo = new InOrderInfo();
            BeanPlusUtil.copyProperties(orderMain, inOrderInfo);
            //装备名称
            String inventoryName = "";
            List<OrderDetail> orderDetailList = orderDetailService.QueryList(orderMain.getId());
            for (OrderDetail orderDetail : orderDetailList) {
                inventoryName = inventoryName + orderDetail.getTypeName() + "/";
            }
            String substring = inventoryName.substring(0, inventoryName.length() - 1);
            inOrderInfo.setInventoryName(substring);
            //查询字典表设置出库类型
//            List<SysDictItem> list = sysDictItemService.list(new LambdaQueryWrapper<SysDictItem>()
//                    .eq(SysDictItem::getItemValue, orderMain.getBussinessType()));
////            inOrderInfo.setOrderType(itemText);
//            System.out.println("list = " + list);
            return inOrderInfo;

        }).collect(Collectors.toList());
        //设置导出的单据序号
        for (int i = 1; i <= collect.size() ; i++) {
            collect.get(i-1).setNumId(i);
        }
        HttpServletResponse response = HttpServletUtil.getResponse();
        ExcelExportParam param = new ExcelExportParam();
        param.setDataList(collect);
        param.setClazz(InOrderInfo.class);
        param.setResponse(response);
        param.setFileName("出库单据列表.xls");
        //对数据进行导出
        officeExcelApi.easyExportDownload(param);
    }


    //判断任务单是否存在
    @Override
    public OrderMain orderMainExist(String id) {
        OrderMain order = this.getById(id);
        if (ObjectUtil.isNull(order)) {
            throw new ServiceException(OrderExceptionEnum.ORDER_NOT_EXIST);
        }
        return order;
    }


    private LambdaQueryWrapper<OrderMain> createWrapper(OrderMainReq req) {
        LambdaQueryWrapper<OrderMain> wrapper = new LambdaQueryWrapper<>();
        if (ObjectUtil.isEmpty(req)) {
            return wrapper;
        }
        //单据类型（in入库，out出库）
        wrapper.eq(ObjectUtil.isNotEmpty(req.getOrderType()),OrderMain::getOrderType,req.getOrderType());
        //单据状态 ready待入/出库，finished已入/出库，working入/出库中
        wrapper.eq(ObjectUtil.isNotEmpty(req.getOrderState()), OrderMain::getOrderState, req.getOrderState());
//        //审核状态:none,未接入审核流，working审批中，finished已完成
        wrapper.eq(ObjectUtil.isNotEmpty(req.getExamineState()), OrderMain::getExamineState, req.getExamineState());
        //业务类型
        wrapper.eq(ObjectUtil.isNotEmpty(req.getBussinessType()), OrderMain::getBussinessType, req.getBussinessType());
        //组织机构id(入库单)
        wrapper.eq(ObjectUtil.isNotEmpty(req.getEndOrgId()),OrderMain::getEndOrgId,req.getEndOrgId());
        //组织机构id（出库单）
        wrapper.ge(ObjectUtil.isNotNull(req.getStartTime()),OrderMain::getCreateTime,req.getStartTime());
        wrapper.le(ObjectUtil.isNotNull(req.getEndTime()),OrderMain::getCreateTime,req.getEndTime());
        wrapper.orderByDesc(OrderMain::getCreateTime);

        return wrapper;

    }


    /**
     * 根据流程id和单据类型查询出该单子据的信息
     * @param req
     * @return
     */
    @Override
    public ProcessOrderDto GetByProcessId(OrderMainReq req) {
        ProcessOrderDto processOrderDto = new ProcessOrderDto();
        System.out.println("req = " + req.getOrderType());
        if (req.getOrderType().equals("null")|| ObjectUtil.isNull(req.getOrderType())) {
            return processOrderDto;
        }
        if (req.getOrderType().equals("workOrder")){
            OrderDto orderDto = new OrderDto();
            OrderMain one = getOne(new LambdaQueryWrapper<OrderMain>()
                    .eq(OrderMain::getProcessId, req.getProcessInstanceId()));
            if (ObjectUtil.isNull(one)){
                return processOrderDto;
            }
            BeanPlusUtil.copyProperties(one,orderDto);

            List<OrderDetailDto> collect = orderDetailService.list(new LambdaQueryWrapper<OrderDetail>()
                    .eq(OrderDetail::getOrderId, one.getId())).stream().map(orderDetail -> {
                OrderDetailDto orderDetailDto = new OrderDetailDto();
                BeanPlusUtil.copyProperties(orderDetail, orderDetailDto);
                return orderDetailDto;
            }).collect(Collectors.toList());
            orderDto.setDetailList(collect);
            processOrderDto.setOrderDto(orderDto);
        } else if (req.getOrderType().equals("bussinessOrder")) {
            BusFormDto busFormDto = new BusFormDto();
            BusForm one = busFormService.getOne(new LambdaQueryWrapper<BusForm>()
                    .eq(BusForm::getProcessId, req.getProcessInstanceId()));
            BeanPlusUtil.copyProperties(one,busFormDto);
            processOrderDto.setBusFormDto(busFormDto);
        } else if (req.getOrderType().equals("stacktakeOrder")) {
            StocktakeDto stocktakeDto = new StocktakeDto();
            Stocktake one = stocktakeService.getOne(new LambdaQueryWrapper<Stocktake>()
                    .eq(Stocktake::getProcessId, req.getProcessInstanceId()));
            BeanPlusUtil.copyProperties(one,stocktakeDto);
            processOrderDto.setStocktakeDto(stocktakeDto);
        } else if (req.getOrderType().equals("reassigment")) {
            ReassignmentDto reassignmentDto = new ReassignmentDto();
            Reassignment one = reassignmentService.getOne(new LambdaQueryWrapper<Reassignment>()
                    .eq(Reassignment::getProcessId, req.getProcessInstanceId()));
            BeanPlusUtil.copyProperties(one,reassignmentDto);
            processOrderDto.setReassignmentDto(reassignmentDto);
        }
        return processOrderDto;
    }



    public boolean addQuickOrder(OrderMain existOrder) {
        //创建新的orderMain入库单
        OrderMain orderMain = new OrderMain();
        BeanPlusUtil.copyProperties(existOrder,orderMain);
        orderMain.setEndOrgId(existOrder.getStartOrgId());
        orderMain.setEndOrgName(existOrder.getStartOrgName());
        orderMain.setOrderType("in");
        orderMain.setId(UUID.randomUUID().toString());
        //工作流流程设为空
        orderMain.setProcessId(null);
        //修改订单编号，设置为入库的单号
        UpdateOrderReq req = new UpdateOrderReq();
        BeanPlusUtil.copyProperties(orderMain,req);
        OrderNum orderNum = setOrderCode(req);
        String codeValue=String.format("%04d",orderNum.getNum());
        orderMain.setOrderCode(orderNum.getBussinessType()+orderNum.getYear()+
                String.format("%02d",LocalDateTime.now().getMonth().getValue())+
                String.format("%02d",LocalDateTime.now().getDayOfMonth())+codeValue);
        //保存入库单
        save(orderMain);
        //查询出库子单用于赋值到入库单中
        List<OrderDetail> list = orderDetailService.list(new LambdaQueryWrapper<OrderDetail>()
                .eq(OrderDetail::getOrderId, existOrder.getId()));
        //查询条件，将所有查询条件放在searchCriteria中，用于修改库存表中的装备的仓库位置
        //原来出库单的查询条件list（根据条件查询库存汇总表中包含有相同条件的数据）
        List<Object[]> searchCriteria=new ArrayList<>();
        //新建的入库单查询条件list（根据条件查询库存汇总表中是否包含有相同条件的数据）
        List<Object[]> updateCriteria=new ArrayList<>();
        //仓库id
        String locationId = orderMain.getLocationId();
        String locationName = orderMain.getLocationName();
        //创建入库单子单
        List<OrderDetail> collect = list.stream().map(orderDetail -> {
            OrderDetail orderDetail1 = new OrderDetail();
            BeanPlusUtil.copyProperties(orderDetail, orderDetail1);
            orderDetail1.setId(null);
            //修改主单据id
            orderDetail1.setOrderId(orderMain.getId());
            //修改单据出入状态
            orderDetail1.setType("in");
            //修改仓库id
            orderDetail1.setWarehouseId(locationId);
            orderDetail1.setWarehouseName(locationName);
            Object[] criteria=new Object[]{existOrder.getStartOrgId(),orderDetail.getWarehouseId(),orderDetail.getTypeId(),orderDetail.getSizeId(),orderDetail.getPrice()};
            searchCriteria.add(criteria);
            Object[] update=new Object[]{orderMain.getEndOrgId(),locationId,orderDetail1.getTypeId(),orderDetail1.getSizeId(),orderDetail1.getPrice()};
            updateCriteria.add(update);
            return orderDetail1;
        }).collect(Collectors.toList());
        orderDetailService.saveBatch(collect);


        //将summary汇总表中数据进行修改(修改该组织机构下的装备汇总信息将库存信息的在库数，库存总数，总价还有其他数据数量进行修改)
        //那么首先将原来的仓库下的装备汇总信息进行查询出来，对其进行修改
        List<InventorySummary> oldSummaryList = inventorySummaryMapper.selectSumByItems(searchCriteria);
        //其次查询出修改后的仓库下面的汇总信息，判断该仓库下是否已经存在该号型、类型、单价相同的装备数据
        List<InventorySummary> newSummaryList = inventorySummaryMapper.selectSumByItems(updateCriteria);
        //第一步：判断是否将报废区的数据也同样进行移库(flag=true表示将报废区的数量进行一起移动)
        boolean flag = oldSummaryList.stream()
                .filter(oldsum -> oldsum.getBrokenNumber() > 0)
                .anyMatch(oldsum -> list.stream()
                        .anyMatch(orderDetail -> orderDetail.getSizeId().equals(oldsum.getSizeId())
                                && orderDetail.getTypeId().equals(oldsum.getTypeId())
                                && orderDetail.getPrice().compareTo(oldsum.getUnitPrice()) == 0
                                && oldsum.getBrokenNumber() + orderDetail.getPlanNum() == oldsum.getStockNumber())
                );
        //创建删除列表用于将没用的数据汇总信息进行删除
        List<InventorySummary> deleteList=new ArrayList<>();
        //将修改的信息直接保存(需要的只是各种数量方便计算)
        List<InventorySummary> saveList=new ArrayList<>();

        //如果整个报废区进行移动，那么将各个数量进行修改
        if (flag){
            for (OrderDetail orderDetail: list ) {
                for (InventorySummary oldSum : oldSummaryList) {
                    //如果组织机构、仓库id、sizeId、typeId、unitPrice相同，那么修改其各项数值（不会存在两个列表长度不对等的情况，一定是一对一的，只不过是顺序问题，所以需要进行遍历）
                    if (orderDetail.getSizeId().equals(oldSum.getSizeId())
                            && orderDetail.getTypeId().equals(oldSum.getTypeId())
                            && orderDetail.getPrice().compareTo(oldSum.getUnitPrice()) == 0) {
                        InventorySummary inventorySummary = new InventorySummary();
                        BeanPlusUtil.copyProperties(oldSum,inventorySummary);
                        inventorySummary.setLocationId(locationId);
                        inventorySummary.setLocationName(locationName);
                        inventorySummary.setNumber(orderDetail.getPlanNum()+oldSum.getOutboundNumber());
                        inventorySummary.setPrice(orderDetail.getPrice().multiply(BigDecimal.valueOf(orderDetail.getPlanNum())));
                        inventorySummary.setStockNumber(orderDetail.getPlanNum());
                        inventorySummary.setDestructionNumber(0);
                        //销毁金额也为0
                        inventorySummary.setDestructionPrice(BigDecimal.ZERO);
                        saveList.add(inventorySummary);
                        //如果存在删减数量完成之后所有的数量值都是0的情况，那么将这一条数据进行删除操作
                        if (oldSum.getDestructionNumber() == 0) {
                            deleteList.add(oldSum);
                        }else {
                            oldSum.setBrokenNumber(0);
                            oldSum.setNumber(0);
                            oldSum.setPrice(BigDecimal.ZERO);
                            oldSum.setStockNumber(0);
                            oldSum.setOutboundNumber(0);
                            oldSum.setUseNumber(0);
                            oldSum.setExpireNumber(0);
                            oldSum.setNearBrokenNumber(0);
                        }
                        break;//查询到直接跳过该循环进入下一循环
                    }
                }
            }
        }else {
            for (OrderDetail orderDetail: list ) {
                for (InventorySummary oldSum : oldSummaryList) {
                    //如果组织机构、仓库id、sizeId、typeId、unitPrice相同，那么修改其各项数值（不会存在两个列表长度不对等的情况，一定是一对一的，只不过是顺序问题，所以需要进行遍历）
                    if (orderDetail.getSizeId().equals(oldSum.getSizeId())
                            && orderDetail.getTypeId().equals(oldSum.getTypeId())
                            && orderDetail.getPrice().compareTo(oldSum.getUnitPrice()) == 0) {
                        InventorySummary inventorySummary = new InventorySummary();
                        BeanPlusUtil.copyProperties(oldSum,inventorySummary);
                        inventorySummary.setLocationId(locationId);
                        inventorySummary.setLocationName(locationName);
                        //在库数量进行修改并且报废数设为0
                        inventorySummary.setBrokenNumber(0);
                        inventorySummary.setNumber(orderDetail.getPlanNum()+oldSum.getOutboundNumber());
                        inventorySummary.setPrice(orderDetail.getPrice().multiply(BigDecimal.valueOf(orderDetail.getPlanNum()+oldSum.getOutboundNumber())));
                        inventorySummary.setStockNumber(orderDetail.getPlanNum());
                        inventorySummary.setDestructionNumber(0);
                        inventorySummary.setDestructionPrice(BigDecimal.ZERO);
                        saveList.add(inventorySummary);

                        oldSum.setNumber(oldSum.getNumber()-orderDetail.getPlanNum());
                        oldSum.setPrice(oldSum.getPrice().subtract(orderDetail.getPrice().multiply(BigDecimal.valueOf(orderDetail.getPlanNum()))));
                        oldSum.setOutboundNumber(0);
                        oldSum.setStockNumber(oldSum.getNumber()-orderDetail.getPlanNum());
                        oldSum.setNearBrokenNumber(0);
                        oldSum.setExpireNumber(0);
                        oldSum.setUseNumber(0);

                        //如果存在删减数量完成之后所有的数量值都是0的情况，那么将这一条数据进行删除操作
                        if (oldSum.getBrokenNumber()==0&& oldSum.getDestructionNumber() == 0) {
                            deleteList.add(oldSum);
                        }
                        break;//查询到直接跳过该循环进入下一循环
                    }
                }
            }
        }

        //判断查询到的newList是否有值，如果有值直接进行修改即可，但是如果不存在，则默认新增一条数据

        if (newSummaryList.size()>0){
            for (InventorySummary save: saveList) {
                for (InventorySummary newsum:newSummaryList) {
                    if (save.getSizeId().equals(newsum.getSizeId())
                            && save.getTypeId().equals(newsum.getTypeId())
                            && save.getPrice().compareTo(newsum.getUnitPrice()) == 0){
                        newsum.setBrokenNumber(save.getBrokenNumber()+newsum.getBrokenNumber());
                        newsum.setNumber(save.getNumber()+newsum.getNumber());
                        newsum.setStockNumber(save.getStockNumber()+newsum.getStockNumber());
                        newsum.setPrice(newsum.getPrice().multiply(BigDecimal.valueOf(newsum.getStockNumber())));
                        newsum.setOutboundNumber(save.getOutboundNumber()+newsum.getOutboundNumber());
                        newsum.setExpireNumber(save.getExpireNumber()+newsum.getExpireNumber());
                        newsum.setNearBrokenNumber(save.getNearBrokenNumber()+newsum.getNearBrokenNumber());
                        newsum.setUseNumber(save.getUseNumber()+newsum.getUseNumber());
                        saveList.remove(save);
                        break;
                    }
                }

            }
        }

        //如果saveList不为空则save
        boolean a=true;
        if(saveList.size()>0){
            a=inventorySummaryService.saveBatch(saveList);
        }
        //如果删除list不为空，那么进行批量删除
        boolean b=true;
        if (deleteList.size()>0){
            b=inventorySummaryService.removeBatchByIds(deleteList);
        }
        //将orderSum和newSum两个列表进行拼接，最终得到一个更新的list进行更新
        List<InventorySummary> totalSumList=new ArrayList<>();
        totalSumList.addAll(oldSummaryList);
        totalSumList.addAll(newSummaryList);
        boolean c =inventorySummaryService.updateBatchById(totalSumList);

        //将库存表inventory中的装备的仓库id进行修改
        //需要判断是否将报废区的数据进行移库，如果移动，那么所有的装备修改仓库id
        //如果保留报废区，那么将报废区的数量不进行修改，其余数据进行修改
        List<Inventory> eqsList = inventoryService.selectEqsByItem(searchCriteria);
        for (Inventory inventory : eqsList) {
            for (OrderDetail detail2 : collect) {
                if (inventory.getOrgId().equals(existOrder.getStartOrgId())
                        && inventory.getSizeId().equals(detail2.getSizeId())
                        && inventory.getTypeId().equals(detail2.getTypeId())
                        && inventory.getPrice().equals(detail2.getPrice())) {
                    // 修改 仓库id
                    inventory.setLocationId(detail2.getWarehouseId());
                    break; // 找到匹配的对象后跳出内循环
                }
            }
        }
        boolean d=inventoryService.updateBatchById(eqsList);
        return true;
    }





}
