package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.dto.LogDetailDto;
import com.junmp.jyzb.api.bean.query.InAndOutRecordReq.OutInLogsReq;
import com.junmp.jyzb.api.bean.query.InventoryReq;
import com.junmp.jyzb.api.bean.query.LogDetailReq;
import com.junmp.jyzb.api.bean.query.LogSummaryReq;
import com.junmp.jyzb.api.bean.req.RabbitMqOrderReq;
import com.junmp.jyzb.entity.LogDetail;
import com.junmp.jyzb.entity.LogSummary;
import com.junmp.jyzb.service.InventorySummaryService;
import com.junmp.jyzb.service.LogDetailService;
import com.junmp.jyzb.service.LogSummaryService;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

@RestController
@Slf4j
@RequestMapping("/OutAndInRecords")
@Api(tags = "出入库模块")
public class OutAndInboundController {


    @Resource
    public LogSummaryService logSummaryService;



    @Resource
    private LogDetailService logDetailService;

    @ApiOperation("/查看出入库详情")
    @PostMapping("/GetDetailByLogSumId")
    public ApiRes<List<LogDetailDto>> GetDetailByLogSumId(@RequestBody @Validated(ValidationApi.detail.class) LogDetailReq req){
        return ApiRes.success(logDetailService.GetDetailByLogSumId(req));
    }

    //装备出入库记录（根据单据id）
    @PostMapping("/ShowInOutRecordsByOrder")
    @ApiOperation("出入库单据查询展示")
    public ApiRes<List<LogDetailDto>> ShowInOutRecordsByOrder(@RequestBody @Validated(ValidationApi.detail.class) LogSummaryReq req){
        return ApiRes.success(logDetailService.ShowInOutRecordsByOrder(req));
    }


    //装备出入库记录（根据条件查询）
    @PostMapping("/ShowInOutRecordsByItems")
    @ApiOperation("出入库记录条件查询展示")
    public ApiRes<PageResult<LogSummary>> ShowInOutRecordsByItems(@RequestBody @Validated(ValidationApi.page.class) LogSummaryReq req){
        return ApiRes.success(logSummaryService.ShowInOutRecordsByItems(req));
    }

    //通过装备id查询某一件装备的出入库记录
    @PostMapping("/ShowInOutRecordsByEqs")
    @ApiOperation("出入库记录装备id查询展示")
    public ApiRes<PageResult<LogDetail>> getInOutRecords(@RequestBody @Validated(ValidationApi.detail.class) InventoryReq req){
        return ApiRes.success(logDetailService.getInOutRecords(req));
    }

//    @PostMapping("/OutInRecords")
//    public ApiRes<Boolean> OutInRecords(@RequestBody OutInLogsReq req){
//        return ApiRes.success(logSummaryService.processInventoryRecords(req));
//    }

}
