package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.req.ProductReq;
import com.junmp.jyzb.api.bean.req.SupplierReq;
import com.junmp.jyzb.api.exception.enums.ProductExceptionEnum;
import com.junmp.jyzb.api.exception.enums.SupplierExceptionEnum;
import com.junmp.jyzb.api.util.GenCodeUtil;
import com.junmp.jyzb.entity.Product;
import com.junmp.jyzb.entity.Supplier;
import com.junmp.jyzb.mapper.ProductMapper;
import com.junmp.jyzb.service.SupplierService;
import com.junmp.jyzb.utils.*;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import com.junmp.jyzb.mapper.SupplierMapper;

import java.util.*;

import static com.junmp.jyzb.utils.CheckBlank.checkNotBlank;

@Service
public class SupplierServiceImpl extends ServiceImpl<SupplierMapper, Supplier> implements SupplierService {

    @Resource
    private SupplierMapper supplierMapper;

    @Resource
    private RedisUtils redisUtils;

    private static final String REDIS_SUPPLIER = "Supplier_";

    @Override
    public boolean addSupplier(SupplierReq req) {
        Supplier supplier = new Supplier();
        BeanPlusUtil.copyProperties(req, supplier);
        return this.save(supplier);
    }

    //@Override
    public ResponseResult addSupplier(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("name"), "name不能为空");
            //checkNotBlank((String) msg.get("shortName"), "shortName不能为空");
            checkNotBlank(msg.get("name"), "name不能为空");
            checkNotBlank(msg.get("code"), "code不能为空");
            checkNotBlank(msg.get("contacts"), "contacts不能为空");
            checkNotBlank(msg.get("phone"), "phone不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }

        Supplier supplier =new Supplier();
        //将警员相关信息添加到警员表
        //生成一个uuid
        String uuid = UUID.randomUUID().toString().replaceAll("-", "");
        //生成当前时间
        Date currentDate = DateTimeUtil.getCurrentDateTime();
        supplier.setId(uuid);
        supplier.setCreateTime(currentDate);
        supplier.setUpdateTime(currentDate);

        supplier.setName((String) msg.get("name"));
        supplier.setShortName((String) msg.get("shortName"));
        supplier.setCode((String) msg.get("code"));
        supplier.setContacts((String) msg.get("contacts"));
        supplier.setPhone((String) msg.get("phone"));
        //supplier.setCreateUser((String) msg.get("createUser"));
        supplierMapper.addSupplier(supplier);

        // 将uuid、创建时间、更新时间加入到policeman中
        msg.put("id",uuid);
        long timestamp = currentDate.getTime(); // 将Date对象转换为long类型的时间戳
        //policeman.put("createTime",timestamp);
        msg.put("updateTime",timestamp);

        /**
         * 更新缓存
         * */
        //构建Redis缓存键
        String redisKey = REDIS_SUPPLIER;
        // 从 Redis 中获取数据
        List<Map<String, Object>> cachedData = redisUtils.findCachedData(redisKey);
        if (cachedData != null) {
            cachedData.add(0,msg);
            //将查询结果存入 Redis 中
            redisUtils.set(redisKey, cachedData);
        }
        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS,uuid);
    }

    @Override
    public Map<String,Object> getOneSupplier(String id,Object name,Object code) {
        //读取msg中的检索信息
        return supplierMapper.getOneSupplier(id,name,code);
    }

    @Override
    public boolean deleteSupplier(SupplierReq req) {
        this.removeById(req.getId());
        return true;
    }

    @Override
    public boolean updateSupplier(SupplierReq req) {
        Supplier supplier = this.querySupplier(req);
        BeanPlusUtil.copyProperties(req, supplier);
        return this.updateById(supplier);
    }

    private Supplier querySupplier(SupplierReq req) {
        Supplier app = this.getById(req.getId());
        if (ObjectUtil.isNull(app)) {
            throw new ServiceException(SupplierExceptionEnum.SUPPLIER_NOT_EXIST);
        }
        return app;
    }

    //@Override
    public ResponseResult deleteSupplier(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("supplierList"), "supplierList不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }
        List<Object> supplierList = (List<Object>) msg.get("supplierList");
        for (Object supplierId:supplierList){
            supplierMapper.deleteSupplier(supplierId.toString());
        }
        return new ResponseResult(HttpStatus.SUCCESS,"操作成功");
    }

    //@Override
    public ResponseResult updateSupplier(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("id"), "id不能为空");
            //checkNotBlank((String) msg.get("shortName"), "shortName不能为空");
            checkNotBlank(msg.get("name"), "name不能为空");
            checkNotBlank(msg.get("code"), "code不能为空");
            checkNotBlank(msg.get("contacts"), "contacts不能为空");
            checkNotBlank(msg.get("phone"), "phone不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }

        Supplier supplier =new Supplier();
        Date currentDate = DateTimeUtil.getCurrentDateTime();
        supplier.setUpdateTime(currentDate);

        supplier.setId((String) msg.get("id"));
        supplier.setName((String) msg.get("name"));
        supplier.setShortName((String) msg.get("shortName"));
        supplier.setCode((String) msg.get("code"));
        supplier.setContacts((String) msg.get("contacts"));
        supplier.setPhone((String) msg.get("phone"));
        //supplier.setUpdateUser((String) msg.get("updateUser"));
        supplierMapper.updateSupplier(supplier);
        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS);
    }

    @Override
    public List<String> getAllSupplierId() {
        List<String> msg = supplierMapper.getAllSupplierId();
        return msg;
    }

    @Override
    public List<Supplier> showSupplier(SupplierReq req) {
        System.out.println(req);


        LambdaQueryWrapper<Supplier> wrapper = createWrapper(req);
        return this.list(wrapper);
    }

    @Override
    public boolean changeSupplierState(SupplierReq req) {
        Supplier supplier = this.querySupplier(req);
        //获取supplierId 放入到 id中
//        supplier.setId(req.getSupplierId());
        //supplier.setId(req);
        BeanPlusUtil.copyProperties(req, supplier);
        return this.updateById(supplier);
    }

    //@Override
    public ResponseResult getAllSupplier(Map<String, Object> msg) {
        String name="";
        String shortName="";

        if (msg.containsKey("name")){
            name = msg.get("name").toString();
        }else if (msg.containsKey("shortName")){
            shortName = msg.get("shortName").toString();
        }

        List<Map<String, Object>> allSupplier=new ArrayList<>();

        //查询所有供应商信息，传入的参数为模糊查询的参数
        allSupplier = supplierMapper.getAllSupplier(name,shortName);

        return new ResponseResult(HttpStatus.SUCCESS,"操作成功",allSupplier);
    }

    //@Override
    public ResponseResult changeSupplierState(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("supplierId"), "supplierId不能为空");
            checkNotBlank(msg.get("state"), "state不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }

        Supplier supplier =new Supplier();

        supplier.setId(msg.get("supplierId").toString());
        supplier.setState((Integer) msg.get("state"));

        supplierMapper.changeSupplierState(supplier);
        return new ResponseResult(HttpStatus.SUCCESS,ReturnMsg.PASS);
    }

    private LambdaQueryWrapper<Supplier> createWrapper(SupplierReq req) {
        LambdaQueryWrapper<Supplier> wrapper = new LambdaQueryWrapper<>();
        if (ObjectUtil.isEmpty(req)) {
            return wrapper;
        }
        //根据供应商短码查询查询
        wrapper.like(ObjectUtil.isNotEmpty(req.getCode()), Supplier::getCode, req.getCode());
        //供应商名称模糊查询
        wrapper.eq(ObjectUtil.isNotEmpty(req.getName()), Supplier::getName, req.getName());
        //根据创建时间降序
        wrapper.orderByDesc(Supplier::getCreateTime);
        return wrapper;
    }
}
