package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.dto.ProductBatchDto;
import com.junmp.jyzb.api.bean.dto.ProductProcessDto;
import com.junmp.jyzb.api.bean.req.ProductBatchReq;
import com.junmp.jyzb.api.exception.enums.ProductExceptionEnum;
import com.junmp.jyzb.api.util.GenCodeUtil;
import com.junmp.jyzb.entity.ProductBatch;
import com.junmp.jyzb.mapper.ProductBatchMapper;
import com.junmp.jyzb.service.ProductBatchService;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.exception.enums.DefaultBizExceptionEnum;
import com.junmp.v2.common.util.BeanPlusUtil;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.db.api.factory.PageResultFactory;
import com.junmp.v2.db.api.page.PageResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2022/7/30 13:47
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Service
@Slf4j
public class ProductBatchServiceImpl extends ServiceImpl<ProductBatchMapper, ProductBatch> implements ProductBatchService {


    @Override
    public boolean addProductBatch(ProductBatchReq req) {
        ProductBatch batch = new ProductBatch();
        BeanPlusUtil.copyProperties(req, batch);
        batch.setHasFinish(false);
        batch.setHasInit(false);
        Integer maxSn = baseMapper.getMaxSn();
        Integer sn = maxSn + 1;
        batch.setSn(sn);

        String batchNo = GenCodeUtil.genBatchNo(sn);
        batch.setBatchNo(batchNo);

        return this.save(batch);
    }

    @Override
    public boolean editProductBatch(ProductBatchReq req) {
        ProductBatch batch = queryBatch(req);
        //如果修改了生产数量大于开始的数量
        if(batch.getHasInit() && (req.getTotal() < batch.getTotal())){
            throw new ServiceException(ProductExceptionEnum.MODIFY_NUM_ERROR);
        }

        if (req.getTotal() > batch.getTotal()) {
            batch.setHasInit(false);
        }
        BeanPlusUtil.copyProperties(req, batch);
        return this.updateById(batch);
    }

    @Override
    public boolean del(ProductBatchReq req) {
        if (null != req && ObjectUtil.isNotNull(req.getBatchId())) {
            ProductBatchDto batch = baseMapper.getBatchProcess(req.getBatchId());
            if (ObjectUtil.isNull(batch)) {
                //批次不存在
                throw new ServiceException(ProductExceptionEnum.BATCH_NOT_EXIST);
            } else {
                if (!batch.getHasFinish() && (batch.getDoneNum() < 1)) {
                    return this.removeById(req.getBatchId());
                } else {
                    throw new ServiceException(ProductExceptionEnum.BATCH_PROCESSED);
                    //生产中不能删除
                }
            }
        } else {
            //参数错误
            throw new ServiceException(DefaultBizExceptionEnum.VALID_PARAMS_ERROR);
        }
    }

    @Override
    public List<ProductBatch> findList(ProductBatchReq req) {
        return this.list(createWrapper(req));
    }

    @Override
    public PageResult<ProductBatchDto> findPage(ProductBatchReq req) {
        Page<ProductBatchDto> page = baseMapper.getBatchPage(PageFactory.getDefaultPage(req), req);
        return PageResultFactory.createPageResult(page);
    }

    @Override
    public PageResult<ProductProcessDto> findProcessPage(ProductBatchReq req) {
        Page<ProductProcessDto> page = baseMapper.getBatchProcessPage(PageFactory.getDefaultPage(req), req);
        return PageResultFactory.createPageResult(page);
    }

    @Override
    public ProductBatchDto getBatchDetail(Long batchId) {
        ProductBatchDto dto = baseMapper.getBatchProcess(batchId);
        if (ObjectUtil.isNull(dto)) {
            throw new ServiceException(ProductExceptionEnum.BATCH_NOT_EXIST);
        }
        return dto;
    }


    private ProductBatch queryBatch(ProductBatchReq req) {
        ProductBatch app = this.getById(req.getBatchId());
        if (ObjectUtil.isNull(app)) {
            throw new ServiceException(ProductExceptionEnum.BATCH_NOT_EXIST);
        }
        return app;
    }


    private LambdaQueryWrapper<ProductBatch> createWrapper(ProductBatchReq req) {
        LambdaQueryWrapper<ProductBatch> wrapper = new LambdaQueryWrapper<>();
        if (ObjectUtil.isEmpty(req)) {
            return wrapper;
        }
        //根据业务编码查询
        wrapper.like(ObjectUtil.isNotEmpty(req.getBatchNo()), ProductBatch::getBatchNo, req.getBatchNo());
        //根据企业名称模糊查询
        wrapper.eq(ObjectUtil.isNotEmpty(req.getProductId()), ProductBatch::getProductId, req.getProductId());
        wrapper.eq(ObjectUtil.isNotEmpty(req.getSpecId()), ProductBatch::getSpecId, req.getSpecId());

        wrapper.orderByDesc(ProductBatch::getCreateTime);
        return wrapper;
    }
}
