package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.req.EquipmentSizeReq;
import com.junmp.jyzb.api.bean.req.ProductReq;
import com.junmp.jyzb.api.exception.enums.ProductExceptionEnum;
import com.junmp.jyzb.api.util.GenCodeUtil;
import com.junmp.jyzb.entity.EquipmentSize;
import com.junmp.jyzb.entity.Product;
import com.junmp.jyzb.mapper.EquipmentTypeMapper;
import com.junmp.jyzb.service.EquipmentSizeService;
import com.junmp.jyzb.utils.DateTimeUtil;
import com.junmp.jyzb.utils.HttpStatus;
import com.junmp.jyzb.utils.ResponseResult;
import com.junmp.jyzb.utils.ReturnMsg;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import com.junmp.jyzb.mapper.EquipmentSizeMapper;

import java.util.*;

import static com.junmp.jyzb.utils.CheckBlank.checkNotBlank;

@Service
public class EquipmentSizeServiceImpl extends ServiceImpl<EquipmentSizeMapper, EquipmentSize> implements EquipmentSizeService {

    @Resource
    private EquipmentSizeMapper equipmentSizeMapper;

    @Resource
    private EquipmentTypeMapper equipmentTypeMapper;

    private static final String REDIS_SIZE = "Size_";

    //@Override
    public ResponseResult addSize(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("typeId"), "typeId不能为空");
            checkNotBlank(msg.get("code"), "code不能为空");
            checkNotBlank(msg.get("name"), "name不能为空");
            //checkNotBlank((String) msg.get("note"), "note不能为空");
            //Objects.requireNonNull(msg.get("price"), "price不能为空");
            Objects.requireNonNull(msg.get("epcType"), "epcType不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }

        //TODO 查询是否有重复的code
//        List<String> sizeCodeFlag = equipmentSizeMapper.getSizeByCode((String) msg.get("code"));
//        if (!sizeCodeFlag.isEmpty()){
//            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,"装备号型码已存在");
//        }

        //todo typeId只能是最下级的
//        List<String> resultId = equipmentTypeMapper.getLowestTypeId();
//        if (!resultId.contains(msg.get("typeId"))){
//            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,"typeId只能是最下一级");
//        }

        EquipmentSize size =new EquipmentSize();
        //生成一个uuid
        String uuid = UUID.randomUUID().toString().replaceAll("-", "");
        //生成当前时间
        Date currentDate = DateTimeUtil.getCurrentDateTime();
        size.setId(uuid);
        size.setCreateTime(currentDate);
        size.setUpdateTime(currentDate);

        size.setTypeId((String) msg.get("typeId"));
        size.setCode((String) msg.get("code"));
        size.setName((String) msg.get("name"));
        size.setNote((String) msg.get("note"));
//        size.setPrice((Double) msg.get("price"));
        size.setEpcType((Integer) msg.get("epcType"));

        equipmentSizeMapper.addSize(size);


        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS,uuid);
    }

    //@Override
    public ResponseResult getOneSize(Map<String,Object> msg) {
        try {
            checkNotBlank(msg.get("id"), "id不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }
        String sizeId = msg.get("id").toString();
        Map<String, Object> oneSize = equipmentSizeMapper.getOneSize(sizeId);
        return new ResponseResult(HttpStatus.SUCCESS,ReturnMsg.PASS,oneSize);
    }

    //@Override
    public ResponseResult deleteSize(Map<String, Object> msg) {
        // 进行参数校验
        try {
            checkNotBlank(msg.get("sizeList"), "sizeList不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }
        List<Object> sizeList = (List<Object>) msg.get("sizeList");
        for (Object sizeId:sizeList){
            equipmentSizeMapper.deleteSize(sizeId.toString());
        }
        return new ResponseResult(HttpStatus.SUCCESS,ReturnMsg.PASS);
    }

    //@Override
    public ResponseResult updateSize(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("id"), "id不能为空");
            checkNotBlank(msg.get("typeId"), "typeId不能为空");
            checkNotBlank(msg.get("code"), "code不能为空");
            checkNotBlank(msg.get("name"), "name不能为空");
            Objects.requireNonNull(msg.get("epcType"), "epcType不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }

        //todo 判断code是否重复
//        //查询是否有重复的code
//        List<String> sizeCodeFlag = equipmentSizeMapper.getSizeByCode((String) msg.get("code"));
//        //判断code是否有变动
//        String oldCode = equipmentSizeMapper.getCodeById(msg.get("id").toString());
//        if ()
//        if (!sizeCodeFlag.isEmpty()){
//            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,"装备号型码已存在");
//        }

        EquipmentSize size =new EquipmentSize();
        Date currentDate = DateTimeUtil.getCurrentDateTime();
        //police.setId(uuid);
        size.setId((String) msg.get("id"));
        size.setTypeId((String) msg.get("typeId"));
        size.setCode((String) msg.get("code"));
        size.setName((String) msg.get("name"));
        size.setNote((String) msg.get("note"));
        size.setUpdateTime(currentDate);
//        size.setPrice((Double) msg.get("price"));
        //size.setState((Integer) msg.get("state"));
        size.setEpcType((Integer) msg.get("epcType"));
        equipmentSizeMapper.updateSize(size);

        return new ResponseResult(HttpStatus.SUCCESS,ReturnMsg.PASS);
    }

    //@Override
    public ResponseResult changeSizeState(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("id"), "id不能为空");
            checkNotBlank(msg.get("state"), "state不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }

        EquipmentSize size =new EquipmentSize();
        size.setId(msg.get("id").toString());
        size.setState((Integer) msg.get("state"));
        equipmentSizeMapper.changeSizeState(size);

        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS);
    }

    //@Override
    public ResponseResult getAllSize(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("typeId"), "typeId不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }

        List<Map<String, Object>> allSize=new ArrayList<>();
        List<String> allSizeId =getAllSizeId(msg);
        for (String sizeId :allSizeId){
            Map<String, Object> sizeMsg = equipmentSizeMapper.getOneSize(sizeId);
            allSize.add(sizeMsg);
        }
        return new ResponseResult(HttpStatus.SUCCESS,ReturnMsg.PASS,allSize);
    }

    @Override
    public List<String> getAllSizeId(Map<String, Object> typeId) {
        List<String> msg = equipmentSizeMapper.getAllSizeId(typeId.get("typeId").toString());
        return msg;
    }

    @Override
    public ResponseResult getSizeDevelop() {
        List<Map<String,Object>> returnMsg = equipmentSizeMapper.getSizeDevelop();
        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS,returnMsg);
    }

    @Override
    public boolean addSize(EquipmentSizeReq req) {
        EquipmentSize size = new EquipmentSize();
        BeanPlusUtil.copyProperties(req, size);
        return this.save(size);
    }

    @Override
    public EquipmentSize getOneSize(EquipmentSizeReq req) {
        //LambdaQueryWrapper<EquipmentSize> wrapper = createWrapperById(req);
        return this.getById(req);
    }

    private LambdaQueryWrapper<EquipmentSize> createWrapperById(EquipmentSizeReq req) {
        LambdaQueryWrapper<EquipmentSize> wrapper = new LambdaQueryWrapper<>();
        if (ObjectUtil.isEmpty(req)) {
            return wrapper;
        }
        //根据id编码查询
        wrapper.eq(ObjectUtil.isNotEmpty(req.getId()), EquipmentSize::getId, req.getId());

        wrapper.orderByDesc(EquipmentSize::getCreateTime);
        return wrapper;
    }

    @Override
    public boolean deleteSize(EquipmentSizeReq req) {
        EquipmentSize size = querySize(req);
        this.removeById(req.getId());
        return true;
    }

    @Override
    public boolean updateSize(EquipmentSizeReq req) {
        EquipmentSize size = this.querySize(req);
        BeanPlusUtil.copyProperties(req, size);
        return this.updateById(size);
    }

    @Override
    public boolean changeSizeState(EquipmentSizeReq req) {
        EquipmentSize size = this.querySize(req);
        BeanPlusUtil.copyProperties(req, size);
        return this.updateById(size);
    }

    @Override
    public List<EquipmentSize> getAllSize(EquipmentSizeReq req) {
        LambdaQueryWrapper<EquipmentSize> wrapper = createWrapper(req);
        return this.list(wrapper);
    }

    private EquipmentSize querySize(EquipmentSizeReq req) {
        EquipmentSize app = this.getById(req.getId());

        if (ObjectUtil.isNull(app)) {
            throw new ServiceException(ProductExceptionEnum.SIZE_NOT_EXIST);
        }
        return app;
    }

    private LambdaQueryWrapper<EquipmentSize> createWrapper(EquipmentSizeReq req) {
        LambdaQueryWrapper<EquipmentSize> wrapper = new LambdaQueryWrapper<>();
        if (ObjectUtil.isEmpty(req)) {
            return wrapper;
        }
        //根据业务编码查询
        wrapper.like(ObjectUtil.isNotEmpty(req.getTypeId()), EquipmentSize::getTypeId, req.getTypeId());
        //根据名称模糊查询
        wrapper.like(ObjectUtil.isNotEmpty(req.getName()), EquipmentSize::getName, req.getName());

        wrapper.orderByDesc(EquipmentSize::getCreateTime);
        return wrapper;
    }
}