package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.req.CabinetReq;
import com.junmp.jyzb.entity.Cabinet;
import com.junmp.jyzb.entity.CabinetBox;
import com.junmp.jyzb.mapper.CabinetBoxMapper;
import com.junmp.jyzb.mapper.CabinetMapper;
import com.junmp.jyzb.service.CabinetBoxService;
import com.junmp.jyzb.utils.HttpStatus;
import com.junmp.jyzb.utils.ResponseResult;
import com.junmp.jyzb.utils.ReturnMsg;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

import static com.junmp.jyzb.utils.CheckBlank.checkNotBlank;

@Service
public class CabinetBoxServiceImpl extends ServiceImpl<CabinetBoxMapper, CabinetBox> implements CabinetBoxService {

    @Resource
    private CabinetBoxMapper cabinetBoxMapper;

    @Resource
    private CabinetBoxService cabinetBoxService;

    @Override
    public List<Map<String, Object>> getAllBoxMsg(String id) {
        return cabinetBoxMapper.getBoxMsg(id);
    }

    /**
         * @author lxh
         * @description 通过cabinetId获取箱门信息列表
         * @since 2023/7/18 22:20
         * @param
         * @return
         **/
    @Override
    public List<CabinetBox> getCabinetBoxList(CabinetReq req) {
        List<CabinetBox> cabinetBoxList = cabinetBoxService.list(new LambdaQueryWrapper<CabinetBox>()
                .eq(ObjectUtil.isNotEmpty(req.getId()),CabinetBox::getCabinetId, req.getId()));
        return cabinetBoxList;
    }
}
