package com.junmp.jyzb.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.junmp.jyzb.Dto.CabinetDto;
import com.junmp.jyzb.entity.Cabinet;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

@Mapper
public interface CabinetMapper extends BaseMapper<Cabinet> {

    public int addCabinet(Cabinet cabinet);

    public List<Cabinet> getAllCabinet();

    public List<Cabinet> getAllCabinetList();

    Map<String, Object> getOneCabinet(String id);

    void deleteCabinet(String id);

    void updateCabinet(Cabinet cabinet);

    List<String> getAllCabinetId(String orgId);

    void changeCabinetState(Cabinet cabinet);

    List<String> getAllCabinetBoxId(String id);

    Map<String, Object> getCabinetByCabinetNum(String cabinetNum);

    List<String> getAllCabinetIdByHighest();

    String getCabinetNumById(String id);

    List<Cabinet> getAllCabinetByOrgList(List<String> allOrgId);
    List<CabinetDto> getAllCabinetByOrgList111(List<String> allOrgId);

    void setCabinetSumInventory(@Param("updateId") String id);

    void setCabinetInSumInventory(@Param("updateId") String id);

    void setCabinetOutSumInventory(@Param("updateId") String id);

    void setCabinetPriceInventory(@Param("updateId") String id);

    List<Map<String, Object>> getCabinetByOrgId(String orgId);

    String getOrgByCabinet(String cabinetId);
}