
package com.junmp.jyzb.exception.enums;

import com.junmp.v2.common.constant.CommonConstant;
import com.junmp.v2.common.exception.IExceptionEnum;
import lombok.Getter;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2022/8/1 13:08
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Getter
public enum CabinetExceptionEnum implements IExceptionEnum {
    /**
     * 组织机构不存在
     */
    PUBORG_NOT_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE,"组织机构不存在"),
    /**
     * 单警柜编号重复
     */
    CABINETID_IS_EXISTS(CommonConstant.DEFAULT_USER_ERROR_CODE,"单警柜编号重复"),
    /**
     * 单警柜不存在
     */
    CABINET_ISNOT_EXISTS(CommonConstant.DEFAULT_USER_ERROR_CODE,"单警柜不存在"),

    /**
     * 传入参数错误
     */
    PARAMETER_ERROR(CommonConstant.DEFAULT_USER_ERROR_CODE,"传入参数错误"),

    /**
     * 箱门id不存在
     */
    CABINETBOX_ISNOT_EXISTS(CommonConstant.DEFAULT_USER_ERROR_CODE,"箱门id不存在"),
    ;


    /**
     * 错误编码
     */
    private final Integer code;

    /**
     * 提示用户信息
     */
    private final String message;

    CabinetExceptionEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
}
