package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <pre>
 *
 * 描述：产品批次
 * 版本：1.0.0
 * 日期：2022/7/29 17:10
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Data
@TableName("biz_product_batch")
public class ProductBatch implements Serializable {

    /**
     * 批次主键
     */
    @TableId(value = "batch_id", type = IdType.AUTO)
    private Long batchId;

    /**
     * 批次编号
     */
    @TableField(value = "batch_no")
    private String batchNo;

    private Integer sn;

    /**
     * 产品编号
     */
    @TableField(value = "product_id")
    private Long productId;

    /**
     * 关联号型
     */
    @TableField(value = "spec_id")
    private Long specId;

    /**
     * 生产总量
     */
    private Integer total;

    /**
     * 序号前缀
     */
    private String prefix;

    /**
     * 复检是否完成
     */
    @TableField(value = "has_finish")
    private Boolean hasFinish;

    /**
     * 生产是否完成
     */
    @TableField(value = "has_init")
    private Boolean hasInit;

    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.UPDATE)
    private Date updateTime;

}
