package com.junmp.jyzb.entity;

import cn.hutool.core.date.DateTime;
import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
* @Author: Zhaojw
* @Description: 库存
* @DateTime: 2023/7/20 10:55
* @Params: 
* @Return 
*/
@Data
@TableName("base_inventory")
public class Inventory implements Serializable {

    @TableId(value = "id",type=IdType.ASSIGN_UUID)
    private String ID;

    /**
     * 装备包ID
     */
    @TableField("package_id")
    private String packageId;

    /**
     * 装备类型ID
     */
    @TableField("type_id")
    private String typeId;
    /**
     * 装备类型ID
     */
    @TableField("size_id")
    private String sizeId;
    /**
     * 供应商ID
     */
    @TableField("supplier_id")
    private String supplierId;

    /**
     * 部门ID
     */
    @TableField("department_id")
    private long departmentId;

    /**
     * 货架位置
     */
    @TableField("shelf_location")
    private String shelfLocation;

    /**
     * 货架id
     */
    @TableField("shelf_id")
    private String shelfId;

    /**
     * epc
     */
    private String epc;

    /**
     * 组织机构ID
     */
    @TableField("org_id_int")
    private Long orgId;

    /**
     * 规格尺寸
     */
    private String state;

    /**
     * 业务状�
     */
    private String bussiness_state;

    /**
     * 位置状�
     */
    @TableField("location_state")
    private String locationState;


    /**
     * 生产日期
     */
    @TableField("production_date")
    private Date productionDate;

    /**
     * 质保�
     */
    @TableField("warranty_period")
    private long warrantyPeriod;

    /**
     * 维保�
     */
    @TableField("maintenance_period")
    private Integer maintenancePeriod;

    /**
     * 维修次数
     */
    @TableField("fix_count")
    private Integer fixCount;
    /**
     * 维修次数
     */
    @TableField("term_state")
    private int TermState;
    /**
     * 位置类型
     */
    @TableField(value = "location_type")
    private Integer locationType;

    /**
     * 位置ID
     */
    @TableField(value = "location_id")
    private String locationId ;

    /**
     * 是否遗失
     */
    @TableField(value = "lost_flag")
    private Integer lostFlag ;


    /**
     * 是否遗失
     */
    private String tid ;

    /**
     * 价格
     */
    private BigDecimal price ;

    /**
     * 备注
     */
    private String note ;


    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.UPDATE)
    private Date updateTime;

    /**
     * 更新人员
     */
    @TableField(value = "update_user", fill = FieldFill.INSERT)
    private String updateUser;

    /**
     * 创建人员
     */
    @TableField(value = "create_user", fill = FieldFill.UPDATE)
    private String createUser;
}