package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel(value = "com-junmp-jyzb-domain-EquipmentType")
@Data
@AllArgsConstructor
@NoArgsConstructor
@TableName("base_equipment_type")
public class EquipmentType implements Serializable {
    /**
     * 装备类型ID
     */
    @ApiModelProperty(value = "装备类型ID")
    @TableId(value = "id", type = IdType.ASSIGN_UUID)
    private String id;

    /**
     * 类型名称
     */
    @ApiModelProperty(value = "类型名称")
    private String name;

    /**
     * 单位
     */
    @ApiModelProperty(value = "单位")
    private String unit;

    /**
     * 单位类型
     */
    @ApiModelProperty(value = "单位类型")
    @TableField("unit_type")
    private String unitType;

    /**
     * 装备Code码
     */
    @ApiModelProperty(value = "装备Code码")
    private String code;

    /**
     * 上级id
     */
    @ApiModelProperty(value = "上级id")
    @TableField("parent_id")
    private String parentId;

    /**
     * 上级ids
     */
    @ApiModelProperty(value = "上级id")
    @TableField("parent_ids")
    private String parentIds;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    @TableField("create_time")
    private Date createTime;

    /**
     * 最后更新时间
     */
    @ApiModelProperty(value = "最后更新时间")
    @TableField("update_time")
    private Date updateTime;

    /**
     * 当前状态:0关闭/1启用
     */
    @ApiModelProperty(value = "当前状态:0关闭/1启用")
    private Integer state;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String note;

    /**
     * 原id
     */
    @ApiModelProperty(value = "原id")
    private String guid;

    /**
     * 类型，0类别，1装备
     */
    @ApiModelProperty(value = "类型，0类别，1装备")
    private Integer type;

    private static final long serialVersionUID = 1L;
}