package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.req.OrgUpdateReq;
import com.junmp.jyzb.service.PubOrgService;
import com.junmp.jyzb.utils.ResponseResult;
import com.junmp.v2.common.bean.response.ApiRes;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

@RestController
@Slf4j
@RequestMapping("/PubOrg")
@Api(tags = "组织机构模块")
public class PubOrgController {
    @Resource
    public PubOrgService pubOrgService;

    @PostMapping("/ShowPubOrgList")
    @ApiOperation("查询组织机构列表_简化版")
    public ApiRes<List<Map<String,Object>>> ShowEquipmentList(@RequestBody Map<String, Object> orgId) {
        //传入当前的组织机构id，展示所有本级及下级的
        //ResponseResult returnMsg = pubOrgService.showPubOrgList(orgId);
        return ApiRes.success(pubOrgService.showPubOrgList(orgId));
    }

//    @PostMapping("/ChangeOrgState")
//    @ApiOperation("改变组织机构状态信息")
//    public ResponseResult changeOrgState(@RequestBody OrgUpdateReq req) {
//        //传入当前的组织机构id，展示所有本级及下级的
//        ResponseResult returnMsg = pubOrgService.changeOrgState(msg);
//        return returnMsg;
//    }

//    @PostMapping("/ShowAllPubOrgList")
//    @ApiOperation("查询组织机构列表(含禁用)")
//    public ResponseResult showAllPubOrgList(@RequestBody Map<String, Object> orgId) {
//        //传入当前的组织机构id，展示所有本级及下级的
//        ResponseResult returnMsg = pubOrgService.showAllPubOrgList(orgId);
//        return returnMsg;
//    }

    @PostMapping("/ShowPubOrgListOld")
    @ApiOperation("查询组织机构列表_完整版")
    public ResponseResult showPubOrgListOld(@RequestBody Map<String, Object> orgId) {
        //传入当前的组织机构id，展示所有本级及下级的
        ResponseResult returnMsg = pubOrgService.showPubOrgListOld(orgId);
        return returnMsg;
    }

    @PostMapping("/SetOrgParentIds")
    @ApiOperation("填充组织机构的parent_ids字段")
    public ResponseResult setOrgParentIds() {
        //传入当前的组织机构id，展示所有本级及下级的
        ResponseResult returnMsg = pubOrgService.setOrgParentIds();
        return returnMsg;
    }

    @PostMapping("/SetDName")
    @ApiOperation("填充组织机构简称到数据库")
    public ResponseResult setShortName(@RequestBody Map<String, Object> orgId) {
        ResponseResult returnMsg = pubOrgService.setShortName(orgId);
        return returnMsg;
    }

    @PostMapping("/GetOrgDetail")
    @ApiOperation("查询组织机构详细信息")
    public ResponseResult getOrgDetail(@RequestBody Map<String, Object> msg) {
        ResponseResult returnMsg = pubOrgService.getOrgDetail(msg);
        return returnMsg;
    }

    @PostMapping("/GetLowerOrg")
    @ApiOperation("获取本级及下级的组织机构")
    public ResponseResult getLowerOrg(@RequestBody Map<String, Object> msg) {
        String orgId = msg.get("orgId").toString();
        List<String> returnMsg = pubOrgService.getLowerOrg(orgId);
        return new ResponseResult(99200,"操作成功",returnMsg);
    }
}
