package com.junmp.jyzb.controller;

import cn.hutool.core.util.ObjectUtil;
import com.junmp.jyzb.api.bean.req.CabinetReq;
import com.junmp.jyzb.api.bean.req.PolicemanReq;
import com.junmp.jyzb.entity.Policeman;
import com.junmp.jyzb.service.PolicemanService;
import com.junmp.jyzb.utils.ResponseResult;
import com.junmp.v2.common.bean.response.ApiRes;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

@RestController
@Slf4j
@RequestMapping("/Police")
@Api(tags = "警员基础信息模块")
public class PoliceController {

    @Resource
    public PolicemanService policemanService;

    @PostMapping("/AddPoliceman")
    @ApiOperation("添加警员信息")
    public ResponseResult addPoliceman(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = policemanService.addPoliceman(msg);
        return returnMsg;
    }


    @PostMapping("/AddFaceInfo")
    @ApiOperation("添加警员面部信息")
    public ApiRes<Boolean> addFaceInfo(@RequestBody PolicemanReq req) {
        boolean b = policemanService.addFaceInfo(req);
        if (!b){
            return ApiRes.failure("添加失败");
        }
        return ApiRes.success(b);
    }

    @PostMapping("/updateFaceInfo")
    @ApiOperation("修改、删除人脸信息")
    public ApiRes<Boolean> updateFaceInfo(@RequestBody PolicemanReq req) {
        boolean b = policemanService.updateFaceInfo(req);
        if (!b){
            return ApiRes.failure("操作失败");
        }
        return ApiRes.success(b);
    }

    @PostMapping("/searchFaceInfo")
    @ApiOperation("查找人脸信息")
    public ApiRes<Policeman> searchFaceInfo(@RequestBody PolicemanReq req) {
        Policeman policeman = policemanService.searchFaceInfo(req);
        if (ObjectUtil.isEmpty(policeman)){
            return ApiRes.failure("未找到警员信息");
        }
        return ApiRes.success(policeman);
    }


    @PostMapping("/DeletePolice")
    @ApiOperation("删除警员信息")
    public ResponseResult deletePolice(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = policemanService.deletePolice(msg);
        return returnMsg;
    }

    @PostMapping("/ChangePoliceState")
    @ApiOperation("修改警员状态")
    public ResponseResult ChangePoliceState(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = policemanService.changePoliceState(msg);
        return returnMsg;
    }

    @PostMapping("/ShowPolice")
    @ApiOperation("查询警员列表")  //根据组织机构id查询
    public ResponseResult getAllPoliceman(@RequestBody Map<String, Object> orgId){
        ResponseResult returnMsg = policemanService.getAllPoliceman(orgId);
        return returnMsg;
    }

    @PostMapping("/GetPoliceDetail")
    @ApiOperation("查询单个警员信息")
    public ResponseResult getOnePolice(@RequestBody Map<String, Object> msg) {
        ResponseResult returnMsg = policemanService.getOnePolice(msg);
        return returnMsg;
    }

    @PostMapping("/UpdatePolice")
    @ApiOperation("修改警员信息")
    public ResponseResult updatePolice(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = policemanService.updatePolice(msg);
        return returnMsg;
    }

    //todo 更新查询所有
    @PostMapping("/GetPoliceData")
    @ApiOperation("查询与单警柜绑定的警员信息")  //根据单警柜id查询
    public ResponseResult getPoliceData(@RequestBody Map<String, Object> cabinetId){
        //获取该组织机构下所有警员的id
        ResponseResult returnMsg =policemanService.getPoliceData(cabinetId);
        return returnMsg;
    }

    @PostMapping("/ChangePoliceOrg")
    @ApiOperation("警员调岗")
    public ResponseResult changePoliceOrg(@RequestBody Map<String, Object> cabinetId){

        return null;
    }
    /**
         * @author lxh
         * @description 单警柜所在的单位下面所有的人员
         * @since 2023/7/19 10:10
         * @param
         * @return
         **/
    @PostMapping("/policeList")
    @ApiOperation("人员列表")
    public ApiRes<List<Policeman>> policeList(@RequestBody CabinetReq req){
        List<Policeman> orgPoliceman = policemanService.getOrgPoliceman(req);
        if (orgPoliceman.isEmpty()){
            return ApiRes.failure("未查到人员信息");
        }
        return ApiRes.success(orgPoliceman);
    }

}
