package com.junmp.jyzb.controller;

import com.junmp.jyzb.service.EquipmentTypeService;
import com.junmp.jyzb.utils.HttpStatus;
import com.junmp.jyzb.utils.ResponseResult;
import com.junmp.v2.common.bean.response.ApiRes;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

@RestController
@Slf4j
@RequestMapping("/Equipment")
@Api(tags = "物资基础信息模块")
public class EquipmentTypeController {
    @Resource
    public EquipmentTypeService equipmentTypeService;

    @PostMapping("/AddEquipment")
    @ApiOperation("添加物资")
    public ResponseResult addEquipment(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = equipmentTypeService.addEquipment(msg);
        return returnMsg;
    }

    //添加装备时计算id
    @PostMapping("/CalculationEquipmentId")
    public ResponseResult calculationEquipmentId() {
        ResponseResult returnMsg = equipmentTypeService.calculationEquipmentId();
        return returnMsg;
    }

    @PostMapping("/DeleteEquipment")
    @ApiOperation("删除装备信息")
    public ResponseResult deleteEquipment(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = equipmentTypeService.deleteEquipment(msg);
        return returnMsg;
    }

    @PostMapping("/ChangeEquipmentState")
    @ApiOperation("禁用/启用装备类型")
    public ResponseResult changeEquipmentState(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = equipmentTypeService.changeEquipmentState(msg);
        return returnMsg;
    }

    @PostMapping("/ShowEquipmentList")
    @ApiOperation("查询类别列表")
    public ApiRes<List<Map<String,Object>>> ShowEquipmentList() {
        return ApiRes.success(equipmentTypeService.getEquipmentList());
    }

    @PostMapping("/ShowAllEquipment")
    @ApiOperation("查询整颗物资树")
    public ResponseResult showAllEquipment() {
        List<Map<String, Object>> equipmentList = equipmentTypeService.showAllEquipment();
//        return new ResponseResult(HttpStatus.SUCCESS,"操作成功",equipmentList);
        return null;
    }

    @PostMapping("/GetEquipmentDetail")
    @ApiOperation("查询单个物资信息")
    public ResponseResult getOneEquipment(@RequestBody Map<String, Object> msg) {
        ResponseResult returnMsg = equipmentTypeService.getOneEquipment(msg);
        return returnMsg;
    }

    @PostMapping("/UpdateEquipment")
    @ApiOperation("修改物资信息")
    public ResponseResult updateEquipment(@RequestBody Map<String,Object> msg) {
        ResponseResult responseMsg = equipmentTypeService.updateEquipment(msg);
        return responseMsg;
    }

    @PostMapping("/ShowEquipmentChildren")
    @ApiOperation("根据类别查询装备")
    public ResponseResult showEquipmentChildren(@RequestBody Map<String,Object> msg) {
        ResponseResult responseMsg = equipmentTypeService.showEquipmentChildren(msg);
        return responseMsg;
    }

    @PostMapping("/SetTypeParentIds")
    @ApiOperation("填充装备类型的parent_ids字段")
    public ResponseResult setTypeParentIds() {
        ResponseResult returnMsg = equipmentTypeService.setTypeParentIds();
        return returnMsg;
    }

    @PostMapping("/GetEquipmentDevelop")
    @ApiOperation("获取装备表所有信息(非树表)")
    public ResponseResult getEquipmentDevelop() {
        ResponseResult returnMsg = equipmentTypeService.getEquipmentDevelop();
        return returnMsg;
    }
}
