package com.junmp.jyzb.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.junmp.jyzb.api.bean.dto.*;
import com.junmp.jyzb.api.bean.dto.TjDto.FinalTjOrgEqsDto;
import com.junmp.jyzb.api.bean.dto.TjDto.TjOrgEqsDto;
import com.junmp.jyzb.api.bean.query.InventoryReq;
import com.junmp.jyzb.api.bean.query.InventorySumReq;
import com.junmp.jyzb.api.bean.query.SelectTotalNumReq;
import com.junmp.jyzb.entity.InventorySummary;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface InventorySummaryMapper  extends BaseMapper<InventorySummary> {

    //用于出库单中的装备选择
    List<InventorySumDto> GetInventorySumInfo(@Param("req") InventorySumReq req);

    //根据仓库id删除装备汇总信息
    boolean deleteByWarehouse(@Param("list") List<WarehouseDto> allWarehouse);

    boolean getSumByWarehouse(@Param("list") List<WarehouseDto> allWarehouse,@Param("brokenNumberDays")Integer brokenNumberDays);

    //根据单警柜删除装备汇总信息
    boolean deleteByCabinet(@Param("cabinetId") String cabinetId);

    boolean getSumByCabinet(@Param("cabinetId") String cabinetId,@Param("brokenNumberDays")Integer brokenNumberDays);

    InventorySummary getTotalNumberAndPrice(@Param("req") InventorySumReq req);

    InventorySummary EquipmentStatistics(@Param("req") InventorySumReq req);

    List<InventorySummary> selectByEqs(@Param("orgId") Long orgId);


    //根据组织机构,仓库,type,size,unitprice查询库存汇总信息
    List<InventorySummary> selectSumByItems(@Param("list") List<Object[]> searchCriteria);

    //根据组织机构查询报表中的本级及下一级信息
    List<TjOrgEqsDto> getByOrgId(@Param("orgId") Long orgId);

    List<EqsSumDto> getEqsByOrgId(@Param("list") List<Long> collect1,@Param("sizeId") String sizeId,@Param("typeId") String typeId);

    List<TjOrgEqsDto> test(@Param("req") InventoryReq req);

    List<TjOrgEqsDto> selectDynamicView();

    void insertToSummary(@Param("summaryTableName") String summaryTableName,@Param("sourceTableName") String sourceTableName, @Param("warrantyThreshold") Integer warrantyThreshold);

    List<TjOrgEqsDto> selectViewOrgeqsSum();

    void useViewOrgeqs(@Param("sql") String sql);

    //获取合计
    FinalTjOrgEqsDto getSumByViewOrgeqsSum();

    int TjOrgEqsDetailSum(@Param("orgId") Long orgId, @Param("typeIdsList") List<String> typeIdsList, @Param("sizeNameList") List<String> sizeNameList);
    List<InventorySumDto> TjOrgEqsDetail(@Param("orgId") Long orgId, @Param("typeIdsList") List<String> typeIdsList,
                                         @Param("sizeNameList") List<String> sizeNameList,
                                         @Param("pageNo")Long pageNo, @Param("pageSize") Long pageSize);


    List<InventorySumDto> selectTotalNum(@Param("orgId") Long orgId,@Param("list") List<Object[]> searchCriteria );
}