package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.dto.InventorySumDto;
import com.junmp.jyzb.api.bean.dto.TjDto.FinalTjOrgEqsDto;
import com.junmp.jyzb.api.bean.dto.TjDto.FinalTjOrgPriceDto;
import com.junmp.jyzb.api.bean.dto.TjDto.TjOrgEqsDto;
import com.junmp.jyzb.api.bean.dto.TjDto.TjOrgPriceDto;
import com.junmp.jyzb.api.bean.query.InventoryReq;
import com.junmp.jyzb.api.bean.query.TjReq.TjOrgEqsReq;
import com.junmp.jyzb.api.bean.query.TjReq.TjOrgPriceReq;
import com.junmp.jyzb.service.TjService;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

@RestController
@Slf4j
@RequestMapping("/Tj")
@Api(tags = "[报表]统计报表模块")
public class TjController {

   @Resource
   private TjService tjService;

    /**
     * ------------------------------------装备统计报表--------------------------------------------
     */

    /**
     * 根据组织机构统计装备的报表数据（外层数据）
     */
    @PostMapping("/TjOrgEqs")
    @ApiOperation("/装备统计报表")
    public ApiRes<PageResult<TjOrgEqsDto>> TjOrgEqs(@RequestBody TjOrgEqsReq req){
        return ApiRes.success(tjService.TjOrgEqs(req));
    }
    @PostMapping("/TjOrgEqsSum")
    @ApiOperation("/装备统计报表汇总")
    public ApiRes<FinalTjOrgEqsDto> TjOrgEqsSum(@RequestBody TjOrgEqsReq req){
        return ApiRes.success(tjService.TjOrgEqsSum(req));
    }
    //装备统计报表（点击+后里面的数据）
    @PostMapping("/TjOrgEqsDetailPage")
    @ApiOperation("/查询组织机构下的装备统计明细分页")
    public ApiRes<PageResult<InventorySumDto>> TjOrgEqsDetailPage(@RequestBody TjOrgEqsReq req){
        return ApiRes.success(tjService.TjOrgEqsDetailPage(req));
    }
    @PostMapping("/TjOrgEqsDetailList")
    @ApiOperation("/查询组织机构下的装备统计明细列表")
    public ApiRes<List<InventorySumDto>> TjOrgEqsDetailList(@RequestBody TjOrgEqsReq req){
        return ApiRes.success(tjService.TjOrgEqsDetailList(req));
    }

    /**
     *-------------------------------------财务统计报表------------------------------------------
     */

    //财务统计报表
    @PostMapping("/TjOrgPrice")
    @ApiOperation("/财务统计报表")
    public ApiRes<PageResult<TjOrgPriceDto>> TjOrgPrice(@RequestBody TjOrgPriceReq req){
        return ApiRes.success(tjService.TjOrgPrice(req));
    }
    @PostMapping("/TjOrgPriceSum")
    @ApiOperation("/财务统计报表汇总")
    public ApiRes<FinalTjOrgPriceDto> TjOrgPriceSum(@RequestBody TjOrgPriceReq req){
        return ApiRes.success(tjService.TjOrgPriceSum(req));
    }

    //财务统计报表（点击+后里面的数据）
    @PostMapping("/TjOrgPriceDetailPage")
    @ApiOperation("/查询组织机构下的财务统计明细")
    public ApiRes<PageResult<TjOrgPriceDto>> TjOrgPriceDetailPage(@RequestBody TjOrgPriceReq req){
        return ApiRes.success(tjService.TjOrgPriceDetailPage(req));
    }
    @PostMapping("/TjOrgPriceDetailList")
    @ApiOperation("/查询组织机构下的财务统计明细")
    public ApiRes<List<TjOrgPriceDto>> TjOrgPriceDetailList(@RequestBody TjOrgPriceReq req){
        return ApiRes.success(tjService.TjOrgPriceDetailList(req));
    }

    /**
     * --------------------------------------使用统计报表-------------------------------------------
     */


    /**
     * --------------------------------------人员统计报表-------------------------------------------
     */

    /**
     * --------------------------------------温湿度记录-------------------------------------------
     */



    @PostMapping("/test")
    public ApiRes<FinalTjOrgEqsDto> test(@RequestBody TjOrgEqsReq req){
        return ApiRes.success(tjService.test(req));
    }


//    @PostMapping("test")
//    public ApiRes<List<TjOrgEqsDto>> test(@RequestBody InventoryReq req){
//        return ApiRes.success(tjService.test(req));
//    }
}
