package com.junmp.jyzb.controller;


import cn.hutool.core.util.ObjectUtil;
import com.junmp.jyzb.api.bean.dto.BussinessInventoryDto;
import com.junmp.jyzb.api.bean.query.BussinessInventoryReq;
import com.junmp.jyzb.api.bean.req.UpdateInventoryReq;
import com.junmp.jyzb.api.bean.req.UploadInventoryReq;
import com.junmp.jyzb.entity.BussinessInventory;
import com.junmp.jyzb.service.BussinessInventoryService;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import com.sun.org.apache.xpath.internal.operations.Bool;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@RestController
@Slf4j
@RequestMapping("/BussinessInventory")
@Api(tags = "[盘点]盘点管理模块")
public class BussinessInventoryController {
    @Resource
    private BussinessInventoryService BussinessInventoryService;

    //盘库申请
    @PostMapping("/AddStocktake")
    @ApiOperation("盘库申请")
    public ApiRes<String> AddStocktake (@RequestBody @Validated(ValidationApi.add.class) UpdateInventoryReq req){
        //判断是否有工作流id，如果有则将状态进行修改
        if (ObjectUtil.isEmpty(req.getProcessDefinitionId()))
        {
            req.setExamineState("none");
        }
        else
        {
            req.setExamineState("working");
        }
        return ApiRes.success(BussinessInventoryService.AddInvOrder(req));
    }

    //盘库申请
    @PostMapping("/Check")
    @ApiOperation("预览盘点单")
    public ApiRes<BussinessInventoryDto> Check (@RequestBody @Validated(ValidationApi.detail.class) BussinessInventoryReq req){
        //判断是否有工作流id，如果有则将状态进行修改

        return ApiRes.success(BussinessInventoryService.Check(req));
    }
    //开始盘点，已废弃
    @PostMapping("/Start")
    @ApiOperation("开始盘点")
    public ApiRes<Boolean> Start (@RequestBody  BussinessInventoryReq req){
        //判断是否有工作流id，如果有则将状态进行修改
        return ApiRes.success(BussinessInventoryService.Start(req));
    }
    //查询列表
    @PostMapping("/GetPage")
    @ApiOperation("查询列表")
    public ApiRes<PageResult<BussinessInventory>> GetPage (@RequestBody  BussinessInventoryReq req){
        //判断是否有工作流id，如果有则将状态进行修改
        return ApiRes.success(BussinessInventoryService.GetPage(req));
    }
    //盘库申请
    @PostMapping("/GetById")
    @ApiOperation("查询详情")
    public ApiRes<BussinessInventoryDto> GetById (@RequestBody  BussinessInventoryReq req){
        //判断是否有工作流id，如果有则将状态进行修改
        return ApiRes.success(BussinessInventoryService.GetDetailById(req));
    }
    //盘库申请
    @PostMapping("/UploadStock")
    @ApiOperation("上传盘点记录")
    public ApiRes<Boolean> UploadStock (@RequestBody UploadInventoryReq req){
        //判断是否有工作流id，如果有则将状态进行修改
        return ApiRes.success(BussinessInventoryService.UploadStock(req));
    }
}
