package com.junmp.jyzb.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.dto.LogSummarySecondDto;
import com.junmp.jyzb.api.bean.dto.OrderLogDto;
import com.junmp.jyzb.api.bean.query.LogSummaryReq;
import com.junmp.jyzb.api.bean.query.QueryLogSummarySecondReq;
import com.junmp.jyzb.entity.OrderLog;
import com.junmp.jyzb.mapper.LogDetailMapper;
import com.junmp.jyzb.service.OrderLogService;
import com.junmp.jyzb.mapper.OrderLogMapper;
import com.junmp.v2.common.util.BeanPlusUtil;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.db.api.factory.PageResultFactory;
import com.junmp.v2.db.api.page.PageResult;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.xml.ws.RequestWrapper;
import java.util.List;
import java.util.stream.Collectors;

/**
* @author lxh专属坐骑
* @description 针对表【bussiness_order_log】的数据库操作Service实现
* @createDate 2023-09-21 11:00:44
*/
@Service
public class OrderLogServiceImpl extends ServiceImpl<OrderLogMapper, OrderLog>
    implements OrderLogService{

    @Resource
    private LogDetailMapper logDetailMapper;

    /**
     * 展示单子从创建到记账全过程
     * @param req
     * @return
     */
    @Override
    public List<OrderLogDto> ShowRecordsByOrderId(LogSummaryReq req) {
        List<OrderLog> list = list(new LambdaQueryWrapper<OrderLog>()
                .eq(OrderLog::getOrderId, req.getOrderMainId())
                .orderByAsc(OrderLog::getCreateTime));
        List<OrderLogDto> collect = list.stream().map(orderLog -> {
            OrderLogDto orderLogDto = new OrderLogDto();
            BeanPlusUtil.copyProperties(orderLog, orderLogDto);
            return orderLogDto;
        }).collect(Collectors.toList());
        return collect;
    }

    @Override
    public PageResult<LogSummarySecondDto> getSecondInfoByLogSumId(QueryLogSummarySecondReq req) {
        List<LogSummarySecondDto> collect=logDetailMapper.getSecondInfoByLogSumId(req,(req.getPageNo()-1)*req.getPageSize(),req.getPageSize());
        int size=logDetailMapper.getSecondInfoByLogSumIdCount(req);
        Page<LogSummarySecondDto> page = PageFactory.getDefaultPage(req.getPageNo(), req.getPageNo());
        page.setRecords(collect);
        page.setTotal(size);
        return PageResultFactory.createPageResult(page);
    }
}




