package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.req.DestoryUnitReq;
import com.junmp.jyzb.api.bean.req.ManufacturerReq;
import com.junmp.jyzb.entity.DestoryUnit;
import com.junmp.jyzb.entity.Manufacturer;
import com.junmp.jyzb.service.DestoryUnitService;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

@RestController
@Slf4j
@Api(tags = "报废/销毁单位模块")
@RequestMapping("/DestoryUnit")
public class DestoryUnitController {
    @Resource
    private DestoryUnitService destoryUnitService;

    //创建报废/销毁单位
    @PostMapping(path="/AddDestoryUnit",name="创建报废/销毁单位")
    @ApiOperation("创建报废/销毁单位")
    public ApiRes<String> addDestoryUnit(@RequestBody @Validated(ValidationApi.add.class) DestoryUnitReq req){
        return ApiRes.success(destoryUnitService.addDestoryUnit(req));
    }

    //修改报废/销毁单位
    @PostMapping(path="/UpdateDestoryUnit",name="修改报废/销毁单位")
    @ApiOperation("修改报废/销毁单位")
    public ApiRes<Boolean> updateDestoryUnit(@RequestBody @Validated(ValidationApi.edit.class) DestoryUnitReq req){
        return ApiRes.success(destoryUnitService.updateDestoryUnit(req));
    }

    //查询报废/销毁单位(list)
    @PostMapping(path="/ShowDestoryUnitList",name="查询报废/销毁单位(list)")
    @ApiOperation("查询报废/销毁单位(list)")
    public ApiRes<List<DestoryUnit>> showDestoryUnitList(@RequestBody DestoryUnitReq req){
        return ApiRes.success(destoryUnitService.showDestoryUnitList(req));
    }

    //查询报废/销毁单位(page)
    @PostMapping(path="/ShowDestoryUnitPage",name="修改报废/销毁单位(page)")
    @ApiOperation("修改报废/销毁单位(page)")
    public ApiRes<PageResult<DestoryUnit>> showDestoryUnitPage(@RequestBody DestoryUnitReq req){
        return ApiRes.success(destoryUnitService.showDestoryUnitPage(req));
    }
    //删除报废/销毁单位
    @PostMapping(path="/DelDestoryUnit",name="修改报废/销毁单位")
    @ApiOperation("修改报废/销毁单位")
    public ApiRes<Boolean> delDestoryUnit(@RequestBody DestoryUnitReq req){
        return ApiRes.success(destoryUnitService.delDestoryUnit(req));
    }
}
