package com.junmp.jyzb.utils;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@Service
public class RedisUtils {
    private static final long REDIS_EXPIRE_TIME = 60*60*2; // 缓存过期时间（单位：秒）默认为两个小时

    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    /**
     * 从 Redis 中获取指定键的缓存数据
     */
    public <T> T get(String key) {
        return (T) redisTemplate.opsForValue().get(key);
    }

    /**
     * 向 Redis 中设置指定键和值的缓存数据，并设置过期时间
     */
    public void set(String key, Object value) {
        if (value != null && !Objects.isNull(value)) {
            // 将查询结果存入 Redis 中
            redisTemplate.opsForValue().set(key, value);
            //redisUtils.set(redisKey, allPoliceman);
        }
    }

    // 从缓存中获取Date类型的数据
    public Date getDate(Long msg) {
        Date date = new Date(msg);
        return date;
//        Long timestamp = (Long) redisTemplate.opsForValue().get(key);
//        return timestamp != null ? new Date(timestamp) : null;
    }

    /**
     * 重载set方法，可以传入自定义的 缓存过期时间
     */
    public void set(String key, Object value,Long time) {
        if (value != null && !Objects.isNull(value)) {
            // 将查询结果存入 Redis 中
            redisTemplate.opsForValue().set(key, value, time, TimeUnit.SECONDS);
        }
    }

    /**
     * 查找是否有缓存数据
     */
    public <T> T findCachedData(String redisKey){
        // 从 Redis 中获取数据
        Object cachedData = get(redisKey);
        if (cachedData != null) {
            // 如果缓存命中，则直接返回缓存数据
            return (T) cachedData;
        }else {
            return null;
        }
    }


    /**
     * 删除 Redis 中指定键的缓存数据
     */
    public void delete(String key) {
        redisTemplate.delete(key);
    }


}