package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.dto.FetchingDataDto.WarehouseDevInfoDto;
import com.junmp.jyzb.api.bean.dto.MQDto;
import com.junmp.jyzb.api.bean.req.UpdateWarehouseDevReq;
import com.junmp.jyzb.entity.WarehouseDev;
import com.junmp.jyzb.service.WarehouseDevService;
import com.junmp.jyzb.mapper.WarehouseDevMapper;
import com.junmp.jyzb.utils.DateTimeUtil;
import com.junmp.jyzb.utils.RabbitMQSendMsg;
import com.junmp.v2.common.util.BeanPlusUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.List;

/**
* @author lxh专属坐骑
* @description 针对表【sys_temp_humidity(温湿度)】的数据库操作Service实现
* @createDate 2023-12-19 08:33:43
*/
@Service
public class WarehouseDevServiceImpl extends ServiceImpl<WarehouseDevMapper, WarehouseDev>
    implements WarehouseDevService {

    @Resource
    private WarehouseDevService warehouseDevService;

    @Resource
    private WarehouseDevMapper warehouseDevMapper;

    @Autowired
    private RabbitMQSendMsg MQ;

    @Override
    public String addWarehouseDev(UpdateWarehouseDevReq req) {
        WarehouseDev warehouseDev = new WarehouseDev();
        BeanPlusUtil.copyProperties(req,warehouseDev);
        warehouseDev.setCreateTime(DateTimeUtil.getCurrentDateTime());
        warehouseDev.setUpdateTime(DateTimeUtil.getCurrentDateTime());
        warehouseDevService.save(warehouseDev);

        String exchangeName="warehouseMsg";
        //判断是否暂存，将消息下发给本地主机
        MQDto mqDto = new MQDto();
        //如果为空或者为false，则将直接发送给本地主机
        if(ObjectUtil.isNull(req.getFlag()) ||!req.getFlag()){
            mqDto.setApi("InfoChange");
            mqDto.setType(6);
            mqDto.setMessage("Adding warehouseDevInfo");
            MQ.SendMsg(exchangeName,req.getOrgId().toString(),mqDto);
        }
        return warehouseDev.getId();
    }

    @Override
    public boolean updateWarehouseDev(UpdateWarehouseDevReq req) {
        WarehouseDev warehouseDev = new WarehouseDev();
        BeanPlusUtil.copyProperties(req,warehouseDev);
        warehouseDev.setUpdateTime(DateTimeUtil.getCurrentDateTime());
        String exchangeName="warehouseMsg";
        //判断是否暂存，将消息下发给本地主机
        MQDto mqDto = new MQDto();
        //如果为空或者为false，则将直接发送给本地主机
        if(ObjectUtil.isNull(req.getFlag()) ||!req.getFlag()){
            mqDto.setApi("InfoChange");
            mqDto.setType(6);
            mqDto.setMessage("Updating warehouseDevInfo");
            MQ.SendMsg(exchangeName,req.getOrgId().toString(),mqDto);
        }
        return warehouseDevService.updateById(warehouseDev);
    }

    @Override
    public List<WarehouseDev> showWarehouseDevList(UpdateWarehouseDevReq req) {
        return warehouseDevMapper.showWarehouseDevList(req);
    }

    @Override
    public List<WarehouseDevInfoDto> alignWarehouseDevInfo(UpdateWarehouseDevReq req) {
        String date = DateTimeUtil.TimeLongToString(req.getUpdateTime());
        return warehouseDevMapper.alignWarehouseDevInfo(req.getOrgId(),date);
    }

}




