package com.junmp.jyzb.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.junmp.jyzb.service.PublicService;
import com.junmp.v2.common.enums.StatusEnum;
import com.junmp.v2.common.util.BeanPlusUtil;
import com.junmp.v2.dict.api.bean.req.SysDictItemReq;
import com.junmp.v2.dict.api.exception.DictException;
import com.junmp.v2.dict.api.exception.DictExceptionEnum;
import com.junmp.v2.dict.entity.SysDictItem;
import com.junmp.v2.dict.service.SysDictItemService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
@Service
@Slf4j
public class PublicServiceImpl implements PublicService {

    @Resource
    private SysDictItemService sysDictItemService;

    public Long addDictType(SysDictItemReq req){
        SysDictItem sysDictType = (SysDictItem) BeanPlusUtil.toBean(req, SysDictItem.class);
        LambdaQueryWrapper<SysDictItem> eq = new LambdaQueryWrapper<SysDictItem>().eq(SysDictItem::getDictId, req.getItemText()).eq(SysDictItem::getItemText, req.getDictId());

        boolean flag = sysDictItemService.count(eq) > 0L;
        if (flag) {
            throw new DictException(DictExceptionEnum.DICT_NAME_REPEAT);
        } else {
            sysDictType.setStatusFlag(StatusEnum.ENABLE.getCode());
            sysDictItemService.save(sysDictType);
        }
        return sysDictType.getDictItemId();
    }

}
