package com.junmp.jyzb.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.dto.FetchingDataDto.DeviceConfigInfoDto;
import com.junmp.jyzb.api.bean.dto.MQDto;
import com.junmp.jyzb.api.bean.query.QueryDeviceConfigReq;
import com.junmp.jyzb.api.bean.req.UpdateDeivceConfigReq;
import com.junmp.jyzb.api.bean.req.UpdateWarehouseDevReq;
import com.junmp.jyzb.entity.DeviceConfig;
import com.junmp.jyzb.entity.WarehouseDev;
import com.junmp.jyzb.mapper.WarehouseDevMapper;
import com.junmp.jyzb.service.DeviceConfigService;
import com.junmp.jyzb.mapper.DeviceConfigMapper;
import com.junmp.jyzb.service.WarehouseDevService;
import com.junmp.jyzb.utils.DateTimeUtil;
import com.junmp.jyzb.utils.RabbitMQSendMsg;
import com.junmp.v2.common.util.BeanPlusUtil;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.db.api.factory.PageResultFactory;
import com.junmp.v2.db.api.page.PageResult;
import net.minidev.json.writer.BeansMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

/**
* @author lxh专属坐骑
* @description 针对表【base_device_config】的数据库操作Service实现
* @createDate 2023-12-19 07:18:22
*/
@Service
public class DeviceConfigServiceImpl extends ServiceImpl<DeviceConfigMapper, DeviceConfig>
    implements DeviceConfigService{

    @Resource
    private DeviceConfigMapper deviceConfigMapper;

    @Autowired
    private RabbitMQSendMsg MQ;



    @Override
    public Long addDeviceConfig(UpdateDeivceConfigReq req) {
        DeviceConfig deviceConfig = new DeviceConfig();
        BeanPlusUtil.copyProperties(req,deviceConfig);
        deviceConfig.setCreateTime(DateTimeUtil.getCurrentDateTime());
        deviceConfig.setUpdateTime(DateTimeUtil.getCurrentDateTime());
        save(deviceConfig);
        String exchangeName="warehouseMsg";
        //判断是否暂存，将消息下发给本地主机
        MQDto mqDto = new MQDto();
        //如果为空或者为false，则将直接发送给本地主机
        if(ObjectUtil.isNull(req.getFlag()) ||!req.getFlag()){
            mqDto.setApi("InfoChange");
            mqDto.setType(8);
            mqDto.setMessage("Adding deviceConfigInfo");
            MQ.SendMsg(exchangeName,req.getOrgId().toString(),mqDto);
        }
        return deviceConfig.getId() ;
    }

    @Override
    public boolean updateDeviceConfig(UpdateDeivceConfigReq req) {
        DeviceConfig deviceConfig = new DeviceConfig();
        BeanPlusUtil.copyProperties(req,deviceConfig);
        deviceConfig.setUpdateTime(DateTimeUtil.getCurrentDateTime());
        String exchangeName="warehouseMsg";
        //判断是否暂存，将消息下发给本地主机
        MQDto mqDto = new MQDto();
        //如果为空或者为false，则将直接发送给本地主机
        if(ObjectUtil.isNull(req.getFlag()) ||!req.getFlag()){
            mqDto.setApi("InfoChange");
            mqDto.setType(8);
            mqDto.setMessage("Updating deviceConfigInfo");
            MQ.SendMsg(exchangeName,req.getOrgId().toString(),mqDto);
        }
        return updateById(deviceConfig);
    }

    @Override
    public PageResult<DeviceConfig> showDeviceConfigPage(QueryDeviceConfigReq req) {
        int size=deviceConfigMapper.showDeviceConfigCount(req);
        if (ObjectUtil.isNull(req.getPageNo()) && ObjectUtil.isNull(req.getPageSize())) {
            req.setPageNo(1L);
            req.setPageSize(10L);
        }
        List<DeviceConfig> list=deviceConfigMapper.showDeviceConfig(req.getOrgId(),req.getDeviceName(),
                req.getDeviceCode(),(req.getPageNo()-1)*req.getPageSize(),req.getPageSize());
        Page<DeviceConfig> page = PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize());
        page.setTotal(size);
        page.setRecords(list);
        return PageResultFactory.createPageResult(page);
    }

    @Override
    public List<DeviceConfig> showDeviceConfigList(QueryDeviceConfigReq req) {
        List<DeviceConfig> list=deviceConfigMapper.showDeviceConfig(req.getOrgId(),req.getDeviceName(),
                req.getDeviceCode(),null,null);
        return list;
    }


    @Override
    public List<String> alignDeviceConfigInfo(UpdateDeivceConfigReq req) {
        String date = DateTimeUtil.TimeLongToString(req.getUpdateTime());
        String deviceConfigString="";
        List<String> deviceConfigList = deviceConfigMapper.alignDeviceConfigInfo(req.getOrgId(), req.getDeviceType(), date);
        if (CollectionUtil.isNotEmpty(deviceConfigList) && deviceConfigList.size()>1 && req.getDeviceType()==1){
            deviceConfigString = deviceConfigList.get(0);
            deviceConfigList.clear();
            deviceConfigList.add(deviceConfigString);

        }

        return deviceConfigList;
    }


}




