package com.junmp.jyzb.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.junmp.jyzb.api.bean.dto.ESTypeDto;
import com.junmp.jyzb.api.bean.dto.EquipmentTypeDto;
import com.junmp.jyzb.api.bean.dto.EquipmentTreeDto;
import com.junmp.jyzb.api.bean.dto.FetchingDataDto.TypeDto;
import com.junmp.jyzb.api.bean.dto.OrgDto;
import com.junmp.jyzb.api.bean.query.QueryEquipmentTypeReq;
import com.junmp.jyzb.api.bean.query.QueryOrgReq;
import com.junmp.jyzb.api.bean.req.UpdateEquipmentTypeReq;
import com.junmp.jyzb.entity.EquipmentType;
import com.junmp.jyzb.utils.ResponseResult;

import java.io.IOException;
import java.util.List;

public interface EquipmentTypeService extends IService<EquipmentType> {

    Object addEs();
    String addEquipment(UpdateEquipmentTypeReq req );
    Boolean deleteEquipment(UpdateEquipmentTypeReq req);
    Boolean updateEquipment(UpdateEquipmentTypeReq msg);
    Boolean changeEquipmentState(UpdateEquipmentTypeReq req);
    List<EquipmentTypeDto> getEquipmentList(QueryEquipmentTypeReq req);
    EquipmentTypeDto getEquipment(QueryEquipmentTypeReq req );
    List<EquipmentTypeDto> getLowType(QueryEquipmentTypeReq orgId);
    ResponseResult setTypeParentIds();

    ESTypeDto getTypeTreeByEs(QueryEquipmentTypeReq req) throws IOException;

    List<EquipmentTreeDto> GetTypeTree(QueryEquipmentTypeReq req);

    List<TypeDto> alignTypeInfo(UpdateEquipmentTypeReq req);

    String exportSizeAndType(QueryEquipmentTypeReq req);
}
