package com.junmp.jyzb.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.junmp.jyzb.api.bean.dto.*;
import com.junmp.jyzb.api.bean.dto.TjDto.FinalTjOrgEqsDto;
import com.junmp.jyzb.api.bean.dto.TjDto.TjOrgEqsDto;
import com.junmp.jyzb.api.bean.query.InventoryReq;
import com.junmp.jyzb.api.bean.query.InventorySumReq;
import com.junmp.jyzb.api.bean.query.SelectTotalNumReq;
import com.junmp.jyzb.entity.InventorySummary;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface InventorySummaryMapper  extends BaseMapper<InventorySummary> {

    //用于出库单中的装备选择
    List<InventorySumDto> GetInventorySumInfo(@Param("req") InventorySumReq req);

    //根据仓库id删除装备汇总信息
    boolean deleteByWarehouse(@Param("list") List<WarehouseDto> allWarehouse);

    boolean getSumByWarehouse(@Param("list") List<WarehouseDto> allWarehouse,@Param("brokenNumberDays")Integer brokenNumberDays);

    //根据单警柜删除装备汇总信息
    boolean deleteByCabinet(@Param("cabinetId") String cabinetId);

    boolean getSumByCabinet(@Param("cabinetId") String cabinetId,@Param("brokenNumberDays")Integer brokenNumberDays);

    InventorySummary getTotalNumberAndPrice(@Param("req") InventorySumReq req);

    InventorySummary EquipmentStatistics(@Param("req") InventorySumReq req);

    List<InventorySummary> selectByEqs(@Param("orgId") Long orgId);


    //根据组织机构,仓库,type,size,unitprice查询库存汇总信息
    List<InventorySummary> selectSumByItems(@Param("list") List<Object[]> searchCriteria);
    List<InventorySummary> selectSum(@Param("list") List<Object[]> searchCriteria);

    //根据组织机构查询报表中的本级及下一级信息
    List<TjOrgEqsDto> getByOrgId(@Param("orgId") Long orgId);

    List<EqsSumDto> getEqsByOrgId(@Param("list") List<Long> collect1,@Param("sizeId") String sizeId,@Param("typeId") String typeId);

    List<TjOrgEqsDto> test(@Param("req") InventoryReq req);

    TjOrgEqsDto GetInvSelfSum(@Param("orgId") String orgId,@Param("typeId") String typeId,@Param("sizeName") String sizeName);
    TjOrgEqsDto GetInvSum(@Param("orgId") String orgId,@Param("typeId") String typeId,@Param("sizeName") String sizeName);
    TjOrgEqsDto GetSumLeve4(@Param("orgId") String orgId,@Param("typeId") String typeId,@Param("sizeName") String sizeName,@Param("sql") Integer sql);

    List<TjOrgEqsDto> selectDynamicView();

    void insertToSummary(@Param("summaryTableName") String summaryTableName,
                         @Param("sourceTableName") String sourceTableName,
                         @Param("warrantyThreshold") Integer warrantyThreshold);

    List<TjOrgEqsDto> selectViewOrgeqsSum();
//    List<TjOrgEqsDto> getTotalDataDetail(@Param("orgId") String orgId, @Param("typeIdsList") List<String> typeIdsList,
//                                         @Param("sizeNameList") List<String> sizeNameList, @Param("levelNum") Integer levelNum);
    List<TjOrgEqsDto> getTotalDataDetail(@Param("orgId") String orgId, @Param("typeIdsList") List<String> typeIdsList,
                                         @Param("sizeNameList") List<String> sizeNameList, @Param("levelNum") Integer levelNum,
                                         @Param("level")Integer level,@Param("column")String column,@Param("order")String order);

    void useViewOrgeqs(@Param("sql") String sql,@Param("orgId") Long orgId,@Param("sql1") String sql1);

    List<String>  getTotalData(@Param("orgId") String orgId);
    //获取合计
    FinalTjOrgEqsDto getSumByViewOrgeqsSum();

    int TjOrgEqsDetailSum(@Param("orgId") Long orgId,
                          @Param("typeIdsList") List<String> typeIdsList,
                          @Param("sizeNameList") List<String> sizeNameList);
    List<InventorySumDto> TjOrgEqsDetail(@Param("orgId") Long orgId, @Param("typeIdsList") List<String> typeIdsList,
                                         @Param("sizeNameList") List<String> sizeNameList,
                                         @Param("pageNo")Long pageNo, @Param("pageSize") Long pageSize);


    List<InventorySumDto> selectTotalNum(@Param("orgId") Long orgId,@Param("list") List<Object[]> searchCriteria );

    int GetEquipmentSummarySum(@Param("req") InventorySumReq req);

    List<InventorySummary> GetEquipmentSummary(@Param("req") InventorySumReq req,
                                               @Param("pageNo") Long pageNo,
                                               @Param("pageSize") Long pageSize);

    List<InventorySummary> GetEquipmentSummaryDetail(@Param("req") InventorySumReq req);

    int selectSumByItemsCount(@Param("req") InventoryReq req);

    List<InventoryDto> GetDetailByTerms(@Param("req") InventoryReq req,
                                        @Param("pageNo") Long pageNo,
                                        @Param("pageSize") Long pageSize);

    void useViewOrgIdInSubordinate(@Param("sql") String sql);

    void useViewOrgIdInLevel(@Param("sql") String sql,@Param("orgId") Long orgId);

    List<Long> selectOrgIds(@Param("orgId") Long orgId);
}