package com.junmp.jyzb.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.junmp.jyzb.api.bean.dto.CabinetPoliceDto;
import com.junmp.jyzb.api.bean.dto.FetchingDataDto.PoliceDto;
import com.junmp.jyzb.api.bean.dto.FetchingDataDto.UserDto;
import com.junmp.jyzb.api.bean.dto.PolicemanDto;
import com.junmp.jyzb.api.bean.dto.ReassignmentDto;
import com.junmp.jyzb.api.bean.dto.UploadPolicePhotoDto;
import com.junmp.jyzb.api.bean.query.CabinetReq;
import com.junmp.jyzb.api.bean.query.PolicemanReq;
import com.junmp.jyzb.api.bean.query.QueryReassignmentReq;
import com.junmp.jyzb.api.bean.req.*;
import com.junmp.jyzb.entity.PoliceEquipment;
import com.junmp.jyzb.entity.Policeman;
import com.junmp.jyzb.entity.Reassignment;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import com.junmp.v2.sys.api.bean.user.SysUserDto;
import com.junmp.v2.sys.api.bean.user.req.SysUserReq;
import com.junmp.v2.sys.api.bean.user.req.UserOrgReq;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

public interface PolicemanService extends IService<Policeman> {

    Object addEs();

    //添加警员
    String AddPoliceman(UpdatePolicemanReq req);
    //添加警员,警柜使用
    String AddPolicemanFromCab(CabinetPolicemanReq req);

    //获取单个警员信息
    PolicemanDto GetOnePolice(PolicemanReq req);


    //删除警员
    boolean DeletePolice(UpdatePolicemanReq req);


    //删除警员
    boolean DeletePoliceFromCab(UpdatePolicemanReq req);
    //修改警员信息
    boolean UpdatePolice(UpdatePolicemanReq req);
    boolean UpdatePoliceFromCab(CabinetPolicemanReq req);

    boolean UploadPolicemanList(CabinetUploadReq req);
    boolean AddFaceInfo(UpdatePolicemanReq req);


    //修改用户状态
    boolean ChangePoliceState(UpdatePolicemanReq req);


    //通过条件查询警员列表(list)
    List<PolicemanDto> GetAllPolicemanList(PolicemanReq req);
    //通过组织机构列表查询
    List<CabinetPoliceDto> GetListByOrgAsync(PolicemanReq req);


    //通过条件查询警员列表(page)
    PageResult<PolicemanDto> GetAllPolicemanPage(PolicemanReq req);

    //根据单警柜id查询警员列表(list)
    List<PolicemanDto> GetPoliceData(CabinetReq req);

    //根据单警柜id查询警员列表(page)
    PageResult<PolicemanDto> GetPoliceDataPage(CabinetReq req);

    boolean UpdateFaceInfo(UpdatePolicemanReq req);

    Policeman SearchFaceInfo(PolicemanReq req);

    //绑定用户
//    boolean PoliceBindUser(PolicemanReq req);

    boolean PoliceBindBox(PolicemanReq req);


    //判断警员信息是否存在
    Policeman PoliceExist(String policeId);

    //删除账号时同时对警员的信息进行更改操作
    boolean UpdatePoliceInfo(UserOrgReq req);

    //警员调岗(业务过程)
    boolean changePoliceOrg(UpdateReassignmentReq req);

    //获取警员的装备信息
    List<PoliceEquipment> GetPoliceEqs(QueryReassignmentReq req);

    //警员调岗业务逻辑
    boolean UpdatePoliceUser();

    //警员调岗申请单
    String PoliceReassignment(UpdateReassignmentReq req);

    //查看警员调岗申请单
    PageResult<Reassignment> ShowReassignmentPage(QueryReassignmentReq req);

    ////查询组织机构下的用户以及角色信息(也可以根据别的查询条件查询)
    PageResult<SysUserDto> ShowUserRole(SysUserReq req);

    //查询没有组织机构的警员信息（添加警员时如果需要则在该列表中）
    List<Policeman> GetPoliceWithoutOrg();

    //添加人脸和指纹照片或修改
    boolean addFaceAndfinger(UpdatePolicemanReq req);

    //查询组织机构为null的警员
    List<PolicemanDto> getPoliceWithoutOrg();

    UploadPolicePhotoDto uploadPolicePhoto(MultipartFile picture,UploadPolicePhotoReq req);

    boolean reSetPassword(SysUserReq req);

    boolean updatePassword(SysUserReq req);

    List<PoliceDto> alignPoliceInfo(PolicemanReq req);

    List<UserDto> alignUserInfo(PolicemanReq req);
}
