package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;


@TableName(value ="base_police_equipment")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class PoliceEquipment implements Serializable {
    /**
     * 主键
     */
    @TableId(value = "id",type = IdType.ASSIGN_UUID)
    @ApiModelProperty(value = "主键ID")
    private String id;

    /**
     * 警员ID
     */
    @TableField(value = "police_id")
    private String policeId;

    @TableField("police_name")
    private String policeName;

    /**
     * 装备号型id
     */
    @TableField("size_id")
    private String sizeId;

    /**
     *装备号型名称
     */
    @TableField("size_name")
    private String sizeName;

    /**
     * 装备类型id
     */
    @TableField("type_id")
    private String typeId;

    /**
     *装备类型名称
     */
    @TableField("type_name")
    private String typeName;

    /**
     * 装备数量
     */
    @TableField("num")
    private Integer num;

    @TableField(value = "in_num")
    private Integer inNum;

    @TableField(value = "out_num")
    private Integer outNum;
    /**
     * 组织机构ID
     */
    @TableField(value = "org_id",updateStrategy = FieldStrategy.IGNORED)
    private Long orgId;

    /**
     * 装备来源仓库id
     */
    @TableField(value = "location_id",updateStrategy = FieldStrategy.IGNORED)
    private String locationId;

    /**
     * 装备存放位置
     */
    @TableField(value = "location_name",updateStrategy = FieldStrategy.IGNORED)
    private String locationName;

    //装备单价
    @TableField("price")
    private BigDecimal price;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private Date updateTime;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private Date createTime;



    private static final long serialVersionUID = 1L;

}