package com.junmp.jyzb.api.bean.req;

import com.junmp.v2.common.bean.request.BaseRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
public class UpdatePolicemanReq extends BaseRequest {

    @NotBlank(message = "警员主键不能为空", groups = {edit.class, delete.class, detail.class})
    private String id;
    private String serialNum;
    @NotBlank(message = "警员名字不能为空", groups = {add.class,edit.class})
    private String name;

    private String cabinetOrgId;

    private String currentCabinetId;
    @NotNull(message = "组织机构id不能为空", groups = {add.class,edit.class})
    private Long orgId;

    private Long departmentId;

    @NotBlank(message = "警员编号不能为空", groups = {add.class,edit.class})
    private String policeCode;


    @NotBlank(message = "人脸信息不能为空", groups = {detail.class})
    private String faceInfo;


    private String doorCode;

    /**
     * 用户名
     */
    private String account;

    private String password;

    private Long fileId;

    private String photo;

    private String phone;

    private String tel;

    private Date createTime;

    private Date updateTime;

    private String idCard;

    private String updateUser;

    @NotNull(message = "状态不能为空", groups = {updateStatus.class})
    private Integer state;

    /**
     * 0警员，1辅警
     */
    private Integer identity;

    /**
     * 角色id列表
     */
    private List<Long> rolesList;
    //当前登录人的id
    private Long createUser;

//    /**
//     * 人脸照片list
//     */
//    private List<String> faceInfoList;
    /**
     * 指纹照片list
     */
    private List<String> fingerList;

    @NotNull(message = "账号不能为空",groups = {updateStatus.class})
    private Long userId;
    private static final long serialVersionUID = 1L;
}