package com.junmp.jyzb.api.bean.query;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.junmp.v2.common.bean.request.BaseRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.ibatis.annotations.Param;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = true)
public class ApplicationReq extends BaseRequest {
    /**
     * 应用id
     */
    private String id;

    /**
     * 应用代码
     */
    @TableField("app_code")
    @NotBlank(message = "应用代码不能为空",groups = {detail.class})
    private String appCode;

    /**
     * 版本号
     */
    private String version;

    /**
     * 应用名称
     */
    @NotBlank(message = "应用名称不能为空",groups = {add.class})
    private String name;

    /**
     * 类型（0内部软件管理，1外部软件管理，2插件/环境安装包）
     */
    @NotNull(message = "应用类型不能为空",groups = {add.class})
    private Integer type;

    /**
     * 应用地址
     */
    private String address;

    /**
     * 备注
     */
    private String note;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 创建人员
     */
    private String createUser;

    /**
     * 更新人员
     */
    private String updateUser;
}
