package com.junmp.jyzb.api.bean.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Data
public class EquipmentTypeDto {

    private String id;
    private String name;
    //别名
    private String nickName;
    private String unit;
    private String unitType;
    private String parentId;
    private String code;
    private Integer state;
    private Integer type;
    private String warrantyPeriod;
    private String maintenancePeriod;
    private Boolean isLeaf;
    private List<String> supplierList;
    private String photo;
    private BigDecimal price;
    private Integer childCount;
    private List<EquipmentTypeDto> children = new ArrayList<>();

    public void addChild(EquipmentTypeDto child) {
        children.add(child);
    }
}
