package com.junmp.jyzb.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.junmp.jyzb.api.bean.dto.ESOrgDto;
import com.junmp.jyzb.api.bean.dto.OrgDto;
import com.junmp.jyzb.api.bean.query.QueryOrgReq;
import com.junmp.jyzb.api.bean.req.UpdateOrgReq;
import com.junmp.jyzb.utils.ResponseResult;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import com.junmp.jyzb.entity.PubOrg;

public interface PubOrgService extends IService<PubOrg> {


    ///添加至ES
    Object AddToEs();

    ResponseResult setShortName(Map<String, Object> orgId);

    List<Long> getLowerOrg(Long orgId);

    ResponseResult setOrgParentIds();

    List<OrgDto> getOrgList(QueryOrgReq req);

    OrgDto getOrgHierarchy(QueryOrgReq req);

    ESOrgDto getOrgTreeByEs(QueryOrgReq req) throws IOException;
    List<OrgDto> getLowOrg(QueryOrgReq req);

    Boolean ChangeState(UpdateOrgReq req);

    //根据组织机构id查询出组织机构是否存在
    PubOrg PubOrgExist(Long id);

    //通过组织机构id获取上一层的组织机构数据
    OrgDto getUpOrgInfo(QueryOrgReq req);

    Long addPubOrg(UpdateOrgReq req);

    boolean updatePubOrg(UpdateOrgReq req);
}
