package com.junmp.jyzb.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.junmp.jyzb.api.bean.dto.OrderDto;
import com.junmp.jyzb.api.bean.dto.OrderMainDto;
import com.junmp.jyzb.api.bean.dto.ProcessOrderDto;
import com.junmp.jyzb.api.bean.query.OrderMainReq;
import com.junmp.jyzb.api.bean.query.OrderUploadReq;
import com.junmp.jyzb.api.bean.query.QueryOrderLogReq;
import com.junmp.jyzb.api.bean.req.UpdateOrderReq;
import com.junmp.jyzb.entity.OrderLog;
import com.junmp.jyzb.entity.OrderMain;
import com.junmp.jyzb.entity.OrderNum;
import com.junmp.v2.db.api.page.PageResult;

import java.util.List;

public interface OrderMainService extends IService<OrderMain> {
    List<String> AddOrder(UpdateOrderReq req);

    boolean delToSubmitOrder(UpdateOrderReq req);

    String AddFinishOrder(UpdateOrderReq req);

    //更新任务单
//    Boolean updateOrder(UpdateOrderReq req);
    Boolean ChangeOrderState(UpdateOrderReq req);

    //判断任务单是否存在
    OrderMain orderMainExist(String id);


    //查询任务列表(根据组织机构id)
    PageResult<OrderMainDto> getOrderPage(OrderMainReq req);

    //根据任务单id查看业务明细
    OrderDto GetDetailById(OrderMainReq req);


    //单据状态上报
    boolean PushState(OrderUploadReq req);

    //
    boolean Accounting(UpdateOrderReq req);

    //查看记账列表
    PageResult<OrderLog> ShowAccountingPage(QueryOrderLogReq req);

    //入库单导出
    void InOrderExport(OrderMainReq req);

    void OutOrderExport(OrderMainReq req);

    ProcessOrderDto GetByProcessId(OrderMainReq req);

     OrderNum setOrderCode(UpdateOrderReq req);


    //快速创建入库单（快速移库内容）
//    boolean addQuickOrder(OrderMain existOrder);
}
