package com.junmp.junmpProcess.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @author : willian fu
 * @date : 2020/9/21
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ProcessTemplates {

    private static final long serialVersionUID = -95829441258242072L;

    @TableId
    /**
     * 审批摸板ID
     */
    private String templateId;
    @TableField(exist = false)
    private String formId;
    private String formName;
    private String orgId;
    @TableField(exist = false)
    private Integer groupId;
    /**
     * 摸板表单
     */
    private String formJson;

    private String settings;

    private String processJson;
    /**
     * 图标
     */
    private String icon;
    /**
     * 图标背景色
     */
    private String background;
    /**
     * 图标背景色
     */
    private String remark;

    private String notify;

    /**
     * 是否已停用
     */
    private Boolean isStop;
    /**
     * 创建时间
     */
    private Date created;
    /**
     * 更新时间
     */
    private Date updated;
    @TableField(exist = false)
    private String logo;
    @TableField(exist = false)
    private String processDefinitionId;
}
